
/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * ParseExecLine:
 * Parse a command line into arguments.
 * Take the raw buffer and construct an array of pointers
 * into it, null terminating each word.
 * Skip over leading blanks and tabs
 * at the beginning.
 *
 * Marvin Theimer, 7/83
 *	Made into a separate library routine.
 * Lance Berc 2/86
 *	Ripped out from the library to add "*" pattern matching.
 */

/* WARNING on the star matching algorithm:
 * In a better world we would match a context here then send the
 * remaining pattern off to the server that implements the context.
 * This would allow one to match on whatever patterns and separators
 * are natural on the target machine, besides being much more
 * efficient.  Instead we force a Unix-style hierarchy, with
 * directories separated by slashes. We also use the V directory
 * protocol to read each directory entry, one message excahnge at a
 * time. This approach runs in 'Qualuude real time'. (lance 12-Feb-86)
 */

#include <Venviron.h>
#include <Vioprotocol.h>
#include <chars.h>
#include "sh.h"

extern DirList *ReadDirectory();

ParseExecLine(lineBuf, BufPtrs, errorString)
char *lineBuf;
PtrRec *BufPtrs;
char **errorString;
  {
    register char *p;
    int star;
    char quote;
    char pat[256];
    int patterns = 0, matches = 0;	/* to check for no matches */

    p = lineBuf;
    while (*p)
      {
	/* Skip over leading blanks and tabs. */
        while (*p && ((*p == ' ') || (*p == TAB))) p++;
        if (!*p) return(0);
	
	/* Parse the next parameter:
	 *	If it is quoted, just pass it along along.
	 *	Otherwise, copy it into the output array,
	 *	then see if there is a '*' to expand. If
	 *	there is one (or more), expand it.
	 */
	if (BufPtrs->argc >= MaxArgs-2)
	  {
	    *errorString = "Too many arguments";
	    return(-1);
	  }
	quote = 0;
	if (*p == '"' || *p == '\'') quote = *p++;
	if (quote)
	  {
	    *(BufPtrs->argv) = p;
	    while (*p && *p != quote) p++;
#ifdef undef /* Not compatible with old semantics */
	    if (*p != quote)
	      {
	        *errorString = "Missing quote";
		return(-1);
	      }
#endif
	    if (*p != 0) *p++ = 0;
            (BufPtrs->argv)++;
	    (BufPtrs->argc)++;
	  }
	else
	  {
	    /* look for a star */
	    star = 0;
	    *(BufPtrs->argv) = p;
	    while (*p && (*p!=' ') && (*p!=TAB)) 
	      {
		if (*p == '*') star = 1;
		p++;
	      }
	    if (*p != 0) *p++ = 0;
	    if (star)
	      {
	        int oldargc = BufPtrs->argc;
		
		strcpy(pat, *(BufPtrs->argv));
 		if (MatchPattern(pat, BufPtrs, errorString) == -1) return(-1);
		++patterns;
		if (BufPtrs->argc != oldargc)
		    ++matches;
	      }
            else
              {
	        (BufPtrs->argv)++;
                (BufPtrs->argc)++;
	      }
	  }		
      }
    if (patterns > 0 && matches == 0)
      {
        *errorString = "No match";
	return(-1);
      }
    *(BufPtrs->argv) = NULL;
    return(0);
  }

MatchPattern(pat, BufPtrs, errorString)
  char *pat;
  PtrRec *BufPtrs;
  char **errorString;
  {
 /*
  * Search for files whose names match pattern 'pat', and
  * put them into 'expandBuf'.
  */

 /*
  * Perform '*' matching using the following algorithm:
  *  1 Put the directory to be searched into 'path'.
  *  2 If the pattern is empty then this is a match. Add
  *    the path to the argument list and return.
  *  3 Put the pattern of the files to be looked for
  *    in this directory into dirpat.
  *  4 Read the directory (closing it after reading).
  *  5 Compare each entry in the directory against dirpat.
  *    If it matches substitute the filename for the pattern
  *    and recurse.
  */

 /*  
  *  ---------------------------------------------------
  *  | clean path | pattern to match | rest of pattern |
  *  ---------------------------------------------------
  *   ^pat         ^star              ^endptr
  *
  *
  *  ----------------------------------------------------
  *  | clean path | file that matches | rest of pattern |
  *  ----------------------------------------------------
  *   ^path        ^slash 
  */

    register char *slash = pat-1;
    register char *star = pat;
    char path[128];
    char *endptr;
    char pathend, c;
    DirList *entrylist, *e1;

    /* look for a star in the pattern */
    while (*star && (*star != '*'))
      {
        if (*star == '/' || *star == ']') slash = star;
        star++;
      }
    if (!*star) /* A match ! */
      {
        if (++(BufPtrs->argc) >= MaxArgs -2)
          {
            *errorString = "Too many arguments";
            return(-1);
	  }
	if ((BufPtrs->expandPtr) + strlen(pat) >
	    (BufPtrs->expandBuf) + ExpandBufLength)
	  {
	    *errorString = "Line too long";
	    return(-1);
	  }
	/* using 'slash' as a temp copy the complete pattern
	   into the buffer space pointed to by *argv.
	*/
	*(BufPtrs->argv) = BufPtrs->expandPtr;
        while (*(BufPtrs->expandPtr)++ = *pat++);
        (BufPtrs->argv)++;
        return(0);
      }

    /* strip the current path from the pattern */
    if (slash < pat)
      {
	 *path = pathend = 0; /* "" is a V convention for the current dir */
      }
    else
      {
        char *ptr1 = path;
        char *ptr2 = pat;
	while (ptr2 <= slash) *ptr1++ = *ptr2++;
	/* knock the trailing '/' off the path */
        if ((pathend = *(ptr2 - 1)) == '/') *(ptr1-1) = 0;else *ptr1 = 0; 
      }
    /* find the next level of directories */
    endptr = star;
    while (*endptr && (*endptr != '/')) endptr++;
    c = *endptr;
    if (*endptr) *endptr++ = 0;

    star = slash+1;

    /* use slash to mark the end of the path */
    slash = path;
    while (*slash) slash++;

    /* read directory names */
    entrylist = ReadDirectory(path);
    
    /* append the slash back onto the path */
    if (pathend == '/') { *slash++ = '/'; *slash = 0; }
    
   /* check each directory entry */
    while (entrylist)
      {
        /* special kludge to prevent matching filenames with leading '.'s */
	if (((*(entrylist->fn) != '.') || (*star == '.')) &&
	    (MatchName(entrylist->fn, star)))
          {
            /* this is a match so far */
            strcat(path, entrylist->fn);
	    if (c) strcat(path, "/");
            strcat(path, endptr);
            if (MatchPattern(path, BufPtrs, errorString) == -1) return(-1);
            *slash = 0;
          }
        free(entrylist->fn);
        e1 = entrylist;
        entrylist = entrylist->link;
        free(e1);
      }
    if (c) *(endptr-1) = c;
    return(0);
  } /* End of MatchPattern */


int MatchName(s,p)
char *s, *p;
  /* see if s matches pattern p */
  {

    /* Find where they differ. */
    while (*s && (*s == *p)) { s++; p++; }

    /* If both strings are empty then they match. */
    if (!*s && !*p) return(1);

    /* If the pattern doesn't contain a star at the differing
     * character then this is not a match */
     if (*p != '*') return(0);
    
    /* Check for trailing star case first as an optimization. */
    if (MatchName("", p+1)) return(1);

    /* attempt to match by successivley 'eating'
     * characters and recursing on the remainder
     * of the source and pattern
     */
    while (*s)
      {
	if (MatchName(s, p+1)) return(1);
	s++;
      }
    return(0);
  } /* End of MatchName */

