/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Io redirection mechanism for V shell.
 * Marvin Theimer.
 *
 * Marvin Theimer, 8/83
 *	File first created.
 * Tim Mann, 9/16/83
 *	Major rework.
 */

#include <Vioprotocol.h>
#include <Vpipe.h>
#include <Vteams.h>
#include "sh.h"

#define FALSE 0
#define TRUE 1

#define PIPE_SERVER_FILE "pipeserver"

ProcessId PipeServerPid = 0;

extern File *Open();
extern ProcessId ExecProgram();
extern ProcessId GetKernelPid();

extern ProcessId GetRemoteHost();
extern ProcessId MapRemoteHost();


/*
 * InitPipeServer:
 * Make sure a pipe server is available.
 */

SystemCode InitPipeServer()
  {
    extern ProcessId NameServerPid;
    char *argv1[2];		/* Used to load the pipeserver. */
    Message msg;
    register RootMessage *rtMsg = (RootMessage *) msg;
    SystemCode error;

    PipeServerPid = GetPid(PIPE_SERVER, LOCAL_PID);
    if ( !ValidPid(PipeServerPid) )
      {
	argv1[0] = PIPE_SERVER_FILE;
	argv1[1] = NULL;
	rtMsg->replycode = OK;
	rtMsg->rootflags = 0;
	rtMsg->stdinserver = stdin->fileserver;
	rtMsg->stdinfile = stdin->fileid;
	rtMsg->stdoutserver = stdout->fileserver;
	rtMsg->stdoutfile = stdout->fileid;
	rtMsg->stderrserver = stdout->fileserver;  /* minor kludge */
	rtMsg->stderrfile = stdout->fileid;

	PipeServerPid = ExecProgram(argv1, 0, rtMsg, NULL, 
						NULL, &error);
	if (PipeServerPid == NULL)
	  {
	    return(error);
	  }
      }
    return(OK);
  }




/*
 * SetUpPipe:
 * Set up a pipe and return the CreateInstanceReply
 */

SystemCode SetUpPipe(pipeReply, shOut)
    File *shOut;
    register CreateInstanceReply *pipeReply;
  {
    register CreatePipeRequest *pipeReq = (CreatePipeRequest *) pipeReply;
    ProcessId localPid = GetPid(ACTIVE_PROCESS, LOCAL_PID);
    SystemCode error;

    if ( !ValidPid(PipeServerPid) )
      {
	error = InitPipeServer();
	if (error != OK)
	  {
	    fprintf(shOut, "ERROR: couldn't create a pipe server: %s\n", 
	        ErrorString(error));
	    return(error);
	  }
      }

    /* Create a pipe. */
    pipeReq->requestcode = CREATE_INSTANCE;
    pipeReq->filemode = FCREATE;
    pipeReq->readowner = localPid;
    pipeReq->writeowner = localPid;
    pipeReq->buffers = 10;
    pipeReq->filename = "pipe";
    pipeReq->filenamelen = 0;
    Send(pipeReq, PipeServerPid);
    if (pipeReply->replycode != OK)
      {
	fprintf(shOut, "ERROR: couldn't create a pipe instance: %s\n", 
	    ErrorString(pipeReply->replycode));
	return(pipeReply->replycode);
      }

    return(OK);
  }






/*
 * RedefineEnvironment:
 * Redefines the execution environment of a command.
 */

SystemCode RedefineEnvironment(ptrArgc, args, concurrent, arbHost, hostSpec,
			       rtMsg, shOut)
    int *ptrArgc;
    char **args;
    int *concurrent;
    int *arbHost;
    register SelectionRec *hostSpec;
    register RootMessage *rtMsg;
    File *shOut;
  {
    Message msg;
    register CreateInstanceReply *creply = (CreateInstanceReply *) msg;
    int argc = *ptrArgc;
    SystemCode error;
    char remoteHostName[128];

    /* Set default if not redirected */
    rtMsg->rootflags = STDOUT_APPEND | STDERR_APPEND;
    
    while (1)			/* Loop until all redefinitions have been
				   processed. */
      {
	/* Check if a concurrent command */
	if( ( argc >= 2 ) && ( Equal( args[argc-1], "&" ) ) )
	  {
	    args[--argc] = NULL; 
			    	/* Eliminate the argument */
	    *concurrent = TRUE;
	  }

	/* Check if a different team server is specified. */
	else if( ( argc >= 3 ) && ( Equal( args[argc-2], "@" ) ) )
	  {
	    if( Equal( args[argc-1], ARBITRARY_REMOTE_HOST_DESIGNATOR ) )
				/* Arbitrary remote host designated. */
	      {
		*arbHost = TRUE;
		hostSpec->teamServerPid = 0; /* to indicate an arbitrary host */
	      }
	    else		/* A specific remote host has been
				   designated. */
	      {
	        if ((args[argc-1][0] == '0') && (args[argc-1][1] == 'x'))
				/* The remote host has been specified by its
				   teamserver's hex pid. */
		  {
		    args[argc-1] += 2;
		    if (sscanf(args[argc-1], "%x", &(hostSpec->teamServerPid))
		         != 1)
		      {
			fprintf(shOut, "ERROR - invalid process-id.\n");
			return(BAD_ARGS);
		      }
		  }
		else		/* The remote host has been specified as a
				   string name. */
		  {
		    hostSpec->teamServerPid = MapRemoteHost(args[argc-1]);
		    if (hostSpec->teamServerPid == 0)
		      {
			fprintf(shOut, 
			   "ERROR - couldn't map the host name specified.\n");
			return(NO_SERVER_RESOURCES);
		      }
		  }
	      }
	    args[argc-2] = NULL;
	    argc -= 2;
	  }

	/* Check for io redirection. */
	else if ((argc >= 3) && ((args[argc-2][0] == '>') ||
			    (args[argc-2][0] == '<')))
	  {
	    if( Equal( args[argc-2], "<" ) )
	      {
		CreateInstance(args[argc-1], FREAD, creply);
		rtMsg->stdinserver = creply->fileserver;
		rtMsg->stdinfile = creply->fileid;
		rtMsg->rootflags |= RELEASE_INPUT;
	      }
	    else if( Equal( args[argc-2], ">" ) )
	      {
		CreateInstance(args[argc-1], FCREATE, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->rootflags |= RELEASE_OUTPUT;
		rtMsg->rootflags &= ~STDOUT_APPEND;
	      }
	    else if( Equal( args[argc-2], ">>" ) )
	      {
		CreateInstance(args[argc-1], FAPPEND, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->rootflags |= RELEASE_OUTPUT + STDOUT_APPEND;
	      }
	    else if( Equal( args[argc-2], ">?" ) )
	      {
		CreateInstance(args[argc-1], FCREATE, creply);
		rtMsg->stderrserver = creply->fileserver;
		rtMsg->stderrfile = creply->fileid;
		rtMsg->rootflags |= RELEASE_ERR;
		rtMsg->rootflags &= ~STDERR_APPEND;
	      }
	    else if( Equal( args[argc-2], ">>?" ) )
	      {
		CreateInstance(args[argc-1], FAPPEND, creply);
		rtMsg->stderrserver = creply->fileserver;
		rtMsg->stderrfile = creply->fileid;
		rtMsg->rootflags |= RELEASE_ERR + STDERR_APPEND;
	      }
	    else if( Equal( args[argc-2], ">&" ) )
	      {
		CreateInstance(args[argc-1], FCREATE, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->stderrserver = creply->fileserver;
		rtMsg->stderrfile = creply->fileid;
		rtMsg->rootflags |= RELEASE_OUTPUT;
		rtMsg->rootflags &= ~(STDOUT_APPEND + STDERR_APPEND);
	      }
	    else if( Equal( args[argc-2], ">>&" ) )
	      {
		CreateInstance(args[argc-1], FAPPEND, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->stderrserver = creply->fileserver;
		rtMsg->stderrfile = creply->fileid;
		rtMsg->rootflags |= STDOUT_APPEND + STDERR_APPEND + 
			RELEASE_OUTPUT;
	      }
	    else if( Equal( args[argc-2], "<>" ) )
	      {
		CreateInstance(args[argc-1], FCREATE, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->stdinserver = creply->fileserver;
		rtMsg->stdinfile = creply->fileid + 1;
		rtMsg->rootflags |= RELEASE_INPUT + RELEASE_OUTPUT;
		rtMsg->rootflags &= ~STDOUT_APPEND;
	      }
	    else if( Equal( args[argc-2], "<>&" ) )
	      {
		CreateInstance(args[argc-1], FCREATE, creply);
		rtMsg->stdoutserver = creply->fileserver;
		rtMsg->stdoutfile = creply->fileid;
		rtMsg->stderrserver = creply->fileserver;
		rtMsg->stderrfile = creply->fileid;
		rtMsg->stdinserver = creply->fileserver;
		rtMsg->stdinfile = creply->fileid + 1;
		rtMsg->rootflags |= RELEASE_INPUT + RELEASE_OUTPUT;
		rtMsg->rootflags &= ~(STDOUT_APPEND + STDERR_APPEND);
	      }


	    if (creply->replycode != OK)
	      {
		fprintf(shOut, "ERROR: couldn't open %s for IO: %s.\n",
			args[argc-1], ErrorString(creply->replycode));
		return(creply->replycode);
	      }
	    args[argc-2] = NULL;
	    argc -= 2;
	  }

	else
	  {
	    break;		/* No more redefinitions to handle. */
	  }
      }
    *ptrArgc = argc;
    return(OK);
  }
