/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Bill Nowicki September 1983
 * Version of GetLine which expects the i/o server to take care of line
 * editing.
 */

/*
 * GetLine:
 * Returns next input line.
 *
 * If InputLineLength > 0, then the inputLine is stuffed into the line
 * buffer and displayed for the user to edit.
 * Returns -1 if EOF, or the number of characters in the line.
 *
 * At most maxLineLength characters will be handled.  Overflow characters are
 * lost.
 */

# include <Vio.h>
# include <Vtermagent.h>
/* Some Debug messages are in here, but at the moment there's no mechanism
 * for activating them.
 */
#define Debug 0

int GetLine(inputLine, inputLineLength, maxLineLength,
	inFile, outFile)
    register char *inputLine;
    int inputLineLength, maxLineLength;
    File *inFile, *outFile;
  {
    register char *s; 
    register int c, n;

    Flush(outFile);
    if (inputLineLength>0) EditLine(inFile,inputLine,inputLineLength);
    ModifyPad(inFile,CR_Input+LF_Output+Echo+LineBuffer+PageOutput);
    s = inputLine; n = maxLineLength-2;
    while (--n>0 && (c = getc(inFile))>=0)
      {
	*s++ = c;
	if (c=='\n' || c==7 /*^G*/)
		break;
      }
    if (c<0 && s==inputLine)
     {
       if (Debug) printf("Exec saw end of file\n");
       return(-1);
     }
    inputLineLength = s - inputLine;
    *s++ = '\0';
    if (inFile->lastexception == EOF ) 
      {
        if (Debug) printf("Exec saw EOF but fgets returned!\n");
        return(-1);
      }
    if (Debug) printf("Exec line length=%d\n", inputLineLength );
    if (inputLineLength > 0 && c != '\007') 
      {
	inputLine[inputLineLength-1] = 0;
        return( inputLineLength-1 );
      }
    return(inputLineLength);
 }
