/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Main program for the standalone exec.
 *
 * Marvin Theimer, 6/83
 */

#include <Venviron.h>
#include <Vio.h>
#include <Vexec.h>
#include "sh.h"

extern AliasRec aliases[];

unsigned long RootStackSize = MainSize;

short ExecDebug;		/* extra debugging information */

/* This structure is a truncated form of ExecDescriptor, containing only
 * the fields which the Exec is going to use.  The only one the standalone
 * Exec reads is ioflags, and we set it to 0 to get normal interactive
 * behavior.
 */
struct {
    ProcessId execPid;		/* pid of exec if any */
    ProcessId programPid;	/* program being executed if any */
    short status;		/* free, loading, or running */
    short ioflags;
    }  fakedescriptor;

char cmdline[512];

extern int SeparateExecProgram;

main(argc, argv)
int argc;
char *argv[];
  {
    SystemCode err;
    register File *fad;

    SeparateExecProgram = 1;
    InitAliases(aliases);
    if (argc == 2)
      {
	/* Read an exec script from the named file */
	fakedescriptor.ioflags = EXEC_NOPROMPT;
	fad = Open(argv[1], FREAD, &err);
	if (err != OK)
	  {
	    fprintf(stderr, "exec: can't open %s - %s\n",
	    	    argv[1], ErrorString(err));
	    exit(err);
	  }
      }
    else if (argc == 3 && strcmp(argv[1], "-c") == 0)
      {
        /* execute the command on the command line */
	/* STRANGENESS WARNING:  we put the command line into a string file
	 * and pass it to Exec as the script file, so it will read the line
	 * and then get an eof
	 */
	sprintf(cmdline, "%s\n", argv[2]);
	fakedescriptor.ioflags = EXEC_NOPROMPT;
	fad = OpenStr(cmdline, strlen(cmdline), &err);
	if (err != OK)
	  {
	    fprintf(stderr, "exec: error on OpenStr!? - %s\n",
	    	    ErrorString(err));
	    exit(err);
	  }
      }
    else
      {
	fakedescriptor.ioflags = 0;
	fad = NULL;
      }

    exit( Exec(stdin, stdout, stderr, fad, &fakedescriptor) );
  }
