/*
 * Configuration file for the UNIX V server.
 * Contains all the site specific manifests.
 */


#define LITTLE_ENDIAN

/* Table lookup (defined in buildfile)
 * #define HOST_TABLE_FILE		"$(VSYS)/run/Vhosttab"
 */
	
/* The user correspondence table, mapping V user numbers to local user names,
 *  and a temporary file used when making changes to the correspondence 
 *  table.  This file must be on the same file system as the original, so that 
 *  rename() can work.
 */
#ifdef EXP_V
#define USER_CORRESPONDENCE_FILE	"/etc/V/xVusercorrespondence"
#define TEMP_CORRESPONDENCE_FILE	"/etc/V/xVusercorrespondence.tmp"
#else EXP_V
#define USER_CORRESPONDENCE_FILE	"/etc/V/Vusercorrespondence"
#define TEMP_CORRESPONDENCE_FILE	"/etc/V/Vusercorrespondence.tmp"
#endif EXP_V

/* Names which appear in UNIX "ps" command field */
#ifndef EXP_V
#define SERVER_BANNER		"V%dserver"
#define SESSION_BANNER		"V%dsession%d"
#else EXP_V
#define SERVER_BANNER		"xV%dserver"
#define SESSION_BANNER		"xV%dsession%d"
#endif EXP_V
#define MAX_BANNER_LEN		16

/* public context (defined in buildfile)
 * #define PUBLIC_DIR		"$(VSYS)/boot/"
 */

/* UNIX signal for */
#define SESSION_INIT_FAILED	29
#define PACKET_RECEIVED		30 
#define SESSION_INITIALIZED	31

/* File creation mode */
#define DEFAULT_CREAT_MODE	0664

#ifndef EXP_V
#define DEBUG_FILE_NAME		"/tmp/VserverDebug%d"
#else EXP_V
#define DEBUG_FILE_NAME		"/tmp/xVserverDebug%d"
#endif EXP_V

/* Different times the server wakes up to check its operation */
#define SLOW_ALARM_RATE		10
#define FAST_ALARM_RATE		2

#define LRU_CLOCK_TICK		60

/* The maximum time (in seconds) that the main server should wait for a new 
 * session to initialize:
 */
#define MAX_SESSION_INIT_TIME	10

/* How long (in seconds) a session process is allowed to be inactive
 * (unless it is maintaining instances with valid owner pids).
 */
#define MINUTES 60
#define MAX_SESSION_INACTIVITY 15*MINUTES

/* Search paths for environment variable and remote program execution */
#define ENV_SEARCH_PATH 	\
    "PATH=.:/usr/local/bin:/usr/stanford/bin:/usr/ucb:/bin:/usr/bin:/etc";

#define PROGRAM_SEARCH_PATH	\
    "/usr/local/bin/",		\
    "/usr/stanford/bin/",	\
    "/usr/ucb/", 		\
    "/bin/", 			\
    "/usr/bin/",		\
    "/etc/"		
