/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 * Kernel (simulator) header file.
 */

#define MAX( A, B )		( (A) > (B) ? (A) : (B) )
#define ROUNDUP( amt, size )	\
	( ((size) + (amt) - 1)&~((amt) - 1) )
#define MAX_NET_HEADER			\
	( ROUNDUP( sizeof( long )	\
		   , MAX( sizeof( Enet3Header ), sizeof( Enet10Header ) ) ) )

#define ENET3_HDR_OFFSET	\
	( MAX_NET_HEADER - sizeof( Enet3Header ) )
#define ENET10_HDR_OFFSET	\
	( MAX_NET_HEADER - sizeof( Enet10Header ) )

struct KernelPacket
  {
    char		header[ MAX_NET_HEADER ];
    kPacketWithSegment	kernelpacket;	/* V portion of packet */
  };

struct SmallKernelPacket
  {
    char		header[ MAX_NET_HEADER ];
    kPacket		kernelpacket;	/* V portion of packet w/o segment */
  };

