/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 * Ethernet access routines
 *
 */

#include "config.h"
#include <errno.h>
#include <types.h>
#include <enet.h>
#include <sgtty.h>
#include <Venviron.h>
#include <Vio.h>
#include <Vioprotocol.h>
#include <Vethernet.h>
#include <Vikc.h>
#include <net.h>
#include <kernel.h>
#include <debug.h>
#include "swab.h"

/* Imports */
extern char *StringName;
extern int Enet3Open(), Enet3Read(), Enet3Write(), Enet3Signal()
	   , Enet3ReceiveQLength();
extern int Enet10Open(), Enet10Read(), Enet10Write(), Enet10Signal()
	   , Enet10ReceiveQLength();
extern int errno;

/* Exports */
int NetworkNum;
int (*NetOpen)(), (*NetRead)(), (*NetWrite)(), (*NetSignal)()
	   , (*NetReceiveQLength)();



InitializeNetwork(mypid, userNumber)
    ProcessId mypid;
    unsigned userNumber;
 /*
  * Figure out what type of network NetworkDeviceName is and
  * set up the network functions to correspond to that network.
  */
 {
    register int i, fid;
    struct endevp EnetDeviceParms;
    char fn[16];
    register int failed = 0;
    extern char *NetworkDeviceName;

    /* Try to open a network device beginning with the given name.
     *
     * Algorithm: assumption is that minors start at 0
     * and run up as decimal numbers without gaps.  We search
     * until we get an error that is not EBUSY (i.e., probably
     * either ENXIO or ENOENT), or until we sucessfully open one.
     */
    for( i=0; !failed ; i++)
      {
	sprintf (fn, "%s%d", NetworkDeviceName, i);
	if( (fid = open(fn, 2)) >= 0 ) 	
	    break;
	/* if we get past the break, we got an error */
	if (errno != EBUSY) failed++;
      }
    if( failed ) return( -1 );

    if( NDebug ) 
    	printf( "Checking device type of \"%s\": ", fn );
    
    ioctl( fid, EIOCDEVP, &EnetDeviceParms );	/* device parameter */

    close( fid );	/* done checking */
    
    switch ( EnetDeviceParms.end_dev_type )
      {
        case ENDT_3MB:	/* 3 megabit network */
	    NetworkNum = 3;
    	    NetOpen = Enet3Open;
    	    NetRead = Enet3Read;
    	    NetWrite = Enet3Write;
    	    NetSignal = Enet3Signal;
    	    NetReceiveQLength = Enet3ReceiveQLength;
	    if ( NDebug )	
	    	printf( "3 megabit ethernet\n" );
	    break;

        case ENDT_10MB:
	    NetworkNum = 10;
    	    NetOpen = Enet10Open;
    	    NetRead = Enet10Read;
    	    NetWrite = Enet10Write;
    	    NetSignal = Enet10Signal;
    	    NetReceiveQLength = Enet10ReceiveQLength;
	    if ( NDebug )
	    	printf( "10 megabit ethernet\n" );
	    break;
	
	default:
	    printf( "InitializeNetwork: unknown net type %d\n", EnetDeviceParms.end_dev_type );
	    exit( 1 );
            break;
      }
    
    return( (*NetOpen)(mypid, userNumber) );

  } /* InitializeNetwork */

