/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 * Kernel (simulator) header file.
 */

#define MAX_LOGICAL_ID 30
#define MOVE_TO_OP	1
#define MOVE_FROM_OP	2
#define VALID_PID_OP	3

#define SMALL_KPACKET sizeof(struct SmallKernelPacket) /* length of packet less data */

#define LOCAL_KERNEL_PROCESS_PID	0x4000
#define COMMON_SERVER_PID		(0x3141|LOCAL_GROUP_BIT)

/* Flags used by the alarm */

#define REPEAT 0
#define DONE 1
#define RETRANSMIT 2
#define NACKED 3


typedef enum
  {
    UNPROCESSED,
    RECEIVED,
    REPLIED,
    FORWARDED
  }
SendRecordState;

/* "SendRecord"s are used to keep track of incoming (remoteSend) messages.  
 * These are linked together in the linked list "SendQueue".  At any time, an 
 * element of "SendQueue" will be in one of the following states (as indicated 
 * by the "state" field):
 *	UNPROCESSED:	The message (in "msg") has arrived, but has yet to be 
 *			processed (i.e. "Receive()d") by anyone.
 *
 *	RECEIVED:	The message (in "msg") has been "Receive()d", but has
 *			not yet been "Reply()d" to (or "Forward()ed").
 *
 *	REPLIED:	The message has been "Reply()d" to.  In this case,
 *			"msg" will contain the reply message.  Such
 *			"SendRecord"s are kept as long as possible, and used
 *			for duplicate suppression.
 *			Note: If the "Reply()" was with an appended segment, 
 *			then the "SendRecord" is discarded immediately.  (In 
 *			such cases the request is assumed to be idempotent.)
 *
 *	FORWARDED:	The message has been "Forward()ed".  In this case,
 *			"msg" will contain the forwarded message.  These
 *			"SendRecord"s are also used for duplicate suppression.
 */
/* Note: We should eventually use a better data structure than a linked list. */
struct SendRecord
  { 
    struct SendRecord *next;	/* next message in queue of messages */
    SendRecordState state;	/* state (see above) */
    ProcessId srcpid;		/* Pid of sending process */
    ProcessId dstpid;		/* Pid that this message was sent to. */
    ProcessId forwarder;	/* Pid of the forwarding process.  However, if
    				 * "state" is "FORWARDED", then this is the 
				 * pid of the process to which the message 
				 * was "Forward()ed", instead.
				 */
    unsigned userNumber;	/* User id of this message */
    unsigned short sequenceNo;	/* Sequence number of this message */
    Message msg;	  	/* The message (see above). */
  };
