/* Add or delete mappings between V user number and local user names. */

#include <Venviron.h>
#include <Vioprotocol.h>
#include <Vsession.h>
#include <pwd.h>
#include "server.h"
#include "debug.h"

SystemCode AddUserCorrespondence(req, pid, segsize)
   register UserCorrespondenceRequest *req;
   ProcessId pid;
   unsigned segsize;
    /* Add a correspondence between the V user number for "pid" and a local
     * user name (deleting any already existing correspondence for this user 
     * number).  The segment consists of a user name (on the remote host),
     * together with a password.  Each is 0-terminated.
     */
  {
    extern SessionDesc *Session;
    extern char BlockBuffer[];
    extern struct passwd *GetUnixPwnam();

    unsigned nameLength;
    SystemCode result;
    char *namePtr;
    char *userName, *givenPassword, *realPassword;
    char *crypt(), *index();
    register struct passwd *pwentry;
    unsigned senderUserNumber;

    /* Make sure that the request is valid.  Note that only the V SUPER_USER 
     * is permitted to set the user correspondence for another V user, or for 
     * the V UNKNOWN_USER.
     */
    senderUserNumber = UserNumber(pid);
    if (senderUserNumber != SUPER_USER &&
        (req->vUserNumber != senderUserNumber ||
	 senderUserNumber == UNKNOWN_USER))
	return(NO_PERMISSION);

    nameLength = req->segmentlen;
    if (nameLength > BUFFER_SIZE) 
        return(ILLEGAL_REQUEST);

    if (Session) 
      { 
	/* Forward the request to the main server, and then commit suicide
	 * (so that the next request will cause a session to be created that
	 * runs as the new local user).
	 */
	extern ProcessId MainServerPid;
	
	Forward(req, pid, MainServerPid);
	KillSession(); /* should not return */
      }

    /* Main server - handle the request: */

    /* Retrieve the user name and password from the segment. */
    /* Been transferred already? */
    if (segsize < nameLength)
      {
	namePtr = req->segmentptr;
	if ((result = MoveFrom(pid, namePtr, BlockBuffer, nameLength)) != OK)
	    return (result);
      }

    BlockBuffer[nameLength] = '\0'; /* terminate password */
    userName = BlockBuffer;
    givenPassword = index(userName, '\0') + 1;

    if (GDebug)
	printf("AddUserCorrespondence - user name = %s\n", userName);

    /* Check the credentials of the user */
    if ((pwentry = GetUnixPwnam(userName)) == NULL)  
        return (BAD_ARGS);

    realPassword = pwentry->pw_passwd;
    /* Dont allow correspondences for root or null password accounts... */
    if (pwentry->pw_uid == 0 || strlen(realPassword) == 0)
	/* ...unless you say the magic word. */
	realPassword = "HAEV4wFH4i3eU";

    /* Check the password */
    givenPassword = crypt(givenPassword, realPassword); /* Encrypt password */
    if (strcmp(givenPassword, realPassword) != 0) 
        return (NO_PERMISSION);

    /* Delete any existing correspondence for this user */
    DeleteCorr(req->vUserNumber);

    /* ... and add the new correspondence */
    return (AddCorr(req->vUserNumber, userName));
  }


SystemCode DeleteUserCorrespondence(req, pid)
   register UserCorrespondenceRequest *req;
   ProcessId pid;
    /* Delete an existing correspondence (if any) between the V user number for
     * "pid" and a local user name.
     */
  {
    extern SessionDesc *Session;
    unsigned senderUserNumber;

    /* Make sure that the request is valid.  Note that only the V SUPER_USER 
     * is permitted to set the user correspondence for another V user, or for 
     * the V UNKNOWN_USER.
     */
    senderUserNumber = UserNumber(pid);
    if (senderUserNumber != SUPER_USER &&
        (req->vUserNumber != senderUserNumber ||
	 senderUserNumber == UNKNOWN_USER))
	return(NO_PERMISSION);

    if (Session) 
      { 
	/* Forward the request to the main server, and then commit suicide
	 * (so that the next request will cause a session to be created that
	 * runs as the new local user).
	 */
	extern ProcessId MainServerPid;
	
	Forward(req, pid, MainServerPid);
	KillSession(); /* should not return */
      }

    /* Main server - handle the request: */

    return (DeleteCorr(req->vUserNumber));
  }
