/*
 * ByteSwapShortCopy()
 *
 *	Swap "n" bytes in 16-bit (half-)words, copying from the source to 
 *	the destination.
 *
 * IMPORTANT: This routine allows "from" == "to", although not general
 *		overlap.
 *
 */

#define	UR_BITS	3		/* lg(# of times loop unrolled) */
#define	UR_TIMES (1<<UR_BITS)	/* # of times loop unrolled */
#define	UR_MASK	(UR_TIMES - 1)

ByteSwapShortCopy(from, to, n)
register char *from, *to;
register int n;
{
	register unsigned long temp;
	
	n >>= 1;	/* n /= 2 */
	n++;
	while ((--n)&UR_MASK) {	/* until remainder is multiple of UR_TIMES */
		temp = *from++;
		*to++ = *from++;
		*to++ = temp;
	}
	
	n >>= UR_BITS;	/* n /= UR_TIMES, # of times for unrolled loop */
	while (--n >= 0) {

#define	STEP	temp = *from++;*to++ = *from++;*to++ = temp;

#if	UR_BITS == 0
		STEP
#endif	UR_BITS == 0

#if	UR_BITS == 1
		STEP
		STEP
#endif	UR_BITS == 1

#if	UR_BITS == 2
		STEP
		STEP
		STEP
		STEP
#endif	UR_BITS == 2

#if	UR_BITS == 3
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
#endif	UR_BITS == 3

#if	UR_BITS == 4
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
#endif	UR_BITS == 4

	}
} /* ByteSwapShortCopy */

ByteSwapShortInPlace(ptr, n)
    register char *ptr;
    register int n;
  {
    ByteSwapShortCopy(ptr, ptr, n);
  }

/* "SwabSmall()" is used by the "ByteSwapIKPacket()" macro in <Vikc.h>. */
swabSmall(ptr, n)
    register char *ptr;
    register int n;
  {
    ByteSwapShortCopy(ptr, ptr, n);
  }

ByteSwapLongCopy( src, dst, length )
    register char *src, *dst;
    register int length;
/*
 * Copies "src" to "dst" by byte swapping long words.
 * "length" is the number of characters to be transfered.
 * NOTE: "src" and "dst" must not be the same buffer.
 */
  {
    /* Round up to an integer number of longs */
    length = ((length + 3) >> 2);
    
    src += 3;
    while ( length-- > 0 )
      {
        *dst++ = *src--; *dst++ = *src--; *dst++ = *src--; *dst++ = *src;
	src += 7;
      }
  } /* ByteSwapLongCopy */


ByteSwapLongInPlace(src, bytes)
    /* byte swap the longs in src without copying them anywhere.  bytes
    *  must be an integral number of longwords (i.e. divisible by four ).
    *  bytes must also be non zero.
    */
register char *src;
register int bytes;
  {
    register char *dst = src + 3;
    register unsigned int temp;

    do
      {
        temp = *src; *src++ = *dst; *dst-- = temp;
        temp = *src; *src++ = *dst; *dst-- = temp;
	src += 2;
	dst += 6;
      } while (bytes -= 4);
  }
