/*
 * Distributed V Kernel 
 * Copyright (c) 1984 by Stanford University, all rights reserved.
 *
 * Query Kernel operation
 */

#include "Venviron.h"
#include "Vquerykernel.h"
#include "debug.h"

/* Imports */
ProcessId LogicalHostPid;

/* Exports */
extern SystemCode QueryKernel();

SystemCode QueryKernel( req, pid )
    register ProcessId pid;
    register QueryKernelRequest *req;
  {

    switch (req->requestcode)
      {
	case LOGICAL_HOST_QUERY: /* Used to detect logical host collisions. */
if (MDebug) printf("Logical Host Query: %x->%x.\n", req->pid, LogicalHostPid);
	    if( req->pid != LogicalHostPid ) return( DISCARD_REPLY );
	    break;

	default:
if (MDebug)printf("QK ignoring %x,%x.\n", req->groupSelect, req->requestcode);
	    return REQUEST_NOT_SUPPORTED;
      }
    return( OK );
  }
