/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 *
 * Dynamic debugging code.
 */
#include "config.h"
#include <stdio.h>
#include <debug.h>

extern int getpid();
extern char *index();
extern FILE *fopen(), *freopen();
extern Session;
int Debug;
char DebugFileName[ 64 ] = { 0 };

SetDebugMode( DebugWord )
    long DebugWord;
/*
 * Change the debugging words to reflect the values in DebugWord.
 * If there isn't a debugging file and any of the bits are set
 * then we must reopen the file as stdout.  If the word is 0, then
 * just turn off the bits.  We want to leave the file open so that
 * we don't have to worry about not having space in the open file
 * table
 */
  {
    char name[ 64 ];
    FILE *file;
    char *ptr;

    if ( Debug != 0 ) 
      {
        /* then we have been debugging and we are just changing the word */
	Debug = DebugWord;
	printf( "Setting the debug mode to be 0x%x\n", Debug );
	fflush( stdout );
	fflush( stderr );
      }
    else if ( DebugWord != 0 )
      {
        /* weren't debugging must open the standard debug file */
	if ( DebugFileName[ 0 ] == 0 )
	    /* have to create a name */
	    sprintf( DebugFileName, DEBUG_FILE_NAME, getpid() );

	/* This is a hack so that we can send to any file */
	/* Try to open the current DebugFileName for reading,
   	   then read the first line and try to open that
	   name for writing.  If this occurs change the 
	   DebugFileName to be the new name
   	 */
	if ( Session != NULL 
	     && (file = fopen( DebugFileName, "r" )) != NULL )
	  {
	    if ( fgets( name, sizeof( name ), file ) != NULL )
	      {
	        if ( (ptr = index( name, '\n')) != NULL )
		    *ptr = 0;

	        fclose( file );
		
		/* check to see if we can open this name for writing */
		if ( close( open( name, 1 ) ) == 0  )
		    strcpy( DebugFileName, name );
	      }
	    else
	        fclose( file );
	  }
	if ( freopen( DebugFileName, "a", stdout ) == NULL
	     || freopen( DebugFileName, "a", stderr ) == NULL )
	  {
	    perror( "Unix Vserver: HELP: unable to open Debug File" );
	    Debug = 0;
	    DebugFileName[ 0 ] = 0;	/* invalidate the name */
   	  }
	else
	  {
	    Debug = DebugWord;
	    printf( "Debug mode is 0x%x\n", Debug );
  	  }
      }
    /* otherwise it is a no-op */
	    
  } /* SetDebugMode */	    
	
