#! /bin/csh -f
# Creates the storage server host table file for SIMPLELOOKUP mode
# of the server. 

# Uses internet lookup to make pids for all hosts specified
# in the argument list.
#
# The 4.1 "host" program prints entries of the form:
# "Diablo HNV SU-HNV-hpp-ng-vax:36.40.0.193 TCP/FTP UDP hostcap=0"
# while the 4.2 version produces a somewhat different format:
# "Diablo HNV SU-HNV-hpp-ng-vax: 36.40.0.193"
#
# The awk script converts either entry to:
# "Diablo	a3040000"
# "HNV	a3040000"
# "SU-HNV-hpp-ng-vax	a3040000"
#
# The pids generated are equal to (subnetNumber<<26)+(hostNumber<<18),
# converted to hex.  The subnet number is included to give a unique
# pid for each host, regardless of what subnet(s) it is on.  Hosts
# that are on several subnets logically have several pids, but only
# the pid generated from the first address returned by "host" is used.
# Note that the two right-hand bits of the logical host number part of the 
# pid are set to zero.  The right-hand bit is zero to indicate that the 
# pid is not a group id.  The next-to-right bit is used to indicate the 
# endianness of the server.  This is set (to 0 or 1, as appropriate) by the
# servers themselves.
# Note that uniqueness is guaranteed as long as subnet numbers in IP 
# addresses don't exceed 64.
#

cat << "END"
# This file was created by hosttab.csh.
# It contains a list of the host machines that are running
# V storage servers.  The number to the right of the name
# is a V system pid (printed in hex).
# 

"END"

set noglob
host $argv | awk \
'{ 								\
    success = 0;						\
    for( i = 1; $i \!~ /:/ && i <= NF; i++ );			\
    if ( split( $i, nameaddr, ":" ) == 2 )			\
      {								\
	if ( nameaddr[2] == "" )				\
	  {							\
	    nameaddr[2] = $(i+1);				\
	  }							\
        if ( split( nameaddr[2], addr, "." ) == 4 )		\
	  {							\
	    success = 1;					\
	    logicalhost = sprintf( "%x0000", addr[2]*1024 + addr[4]*4 );\
	    for( j = 1; j < i; j++ )				\
	        printf( "%s\t%s\n", $j, logicalhost );		\
	    printf( "%s\t%s\n", nameaddr[1], logicalhost ); 	\
	  }							\
      }								\
           if ( \!success )					\
      {								\
        print "#ERROR - unable to parse next line"		\
        print "#"$0						\
      }								\
}'
