/*
 * padtest.c - test the pad primitive of the VGTS
 *
 * Written by Bill Nowicki April 1983
 */

# include <Vio.h>
# include <Vgts.h>

main()
 {
     char c;

     while (1)
       {
         printf("Pad test program\n");
	 printf(" c - pad creation test, user positioned\n");
	 printf(" p - pad creation test, program positioned\n");
	 printf(" m - basic mouse test\n");
	 printf(" s - mouse status test\n");
	 printf(" e - event queue test\n");
	 printf(" q - Quit\n");
	 printf("Enter option:");
	 Flush(stdout);
	 c = getchar();
	 printf("\n");
	 switch (c)
	   {
	     case 'q':  exit();
	     case 'c': CreateTest();	break;
	     case 'p': PositionTest();	break;
	     case 'm': MouseTest();	break;
	     case 's': StatusTest();	break;
	     case 'e': EventTest();	break;
	     case 'z': ZapTest();	break;
	     default:
	     		printf("Undefined option\n");
	   }
       }
  }


CreateTest()
  {
     File *test, *in, *OpenPad();
     SystemCode err;
     char c;

     printf("Pad Creation test\n");
     Flush(stdout);
     test = OpenPad( "Test", 48, 80, &err );
     if (test==NULL)
       {
         printf("Error %s opening the pad\n", ErrorString(err) );
         return;
       }
     in = OpenFile( test->fileserver, test->fileid, FREAD, &err );
     if (in==NULL)
       {
         printf("Error %s opening the input\n", ErrorString(err) );
	 Close(test);
       }
      SelectPad(test);
      fprintf( test, "This is printed on the new pad\n");
      fprintf( test, "Type a character:");
      Flush(test);
      c = getc(in);
      fprintf( test, "\nYou typed %c\n", c);
      fprintf( test, "Type something else:");
      Flush(test);
      c = getc(in);
      fprintf( test, "\nGoodbye!\n");      
      Flush(test);
      Close(test);
   }


PositionTest()
  {
     File *test, *in, *OpenAndPositionPad();
     SystemCode err;
     char c;

     printf("Pad Creation test\n");
     Flush(stdout);
     test = OpenAndPositionPad("Test Again", 100, 100, 10, 80, &err);
     if (test==NULL)
       {
         printf("Error %s opening the pad\n", ErrorString(err) );
         return;
       }
     in = OpenFile( test->fileserver, test->fileid, FREAD, &err );
     if (in==NULL)
       {
         printf("Error %s opening the input\n", ErrorString(err) );
	 Close(test);
       }
      SelectPad(test);
      fprintf( test, "This is printed on the new pad\n");
      fprintf( test, "Type a character:");
      Flush(test);
      c = getc(in);
      fprintf( test, "\nYou typed %c\n", c);
      fprintf( test, "Type something else:");
      Flush(test);
      c = getc(in);
      fprintf( test, "\nGoodbye!\n");      
      Flush(test);
      Close(test);
   }


EventTest()
  {
    short vgt, sdf, hit, x, y, buttons;
    printf("Event test.\n");
    sdf = CreateSDF();
    vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, 0, "queue test");
    CreateView(vgt, 4, 400, 500, 800, 0, 0, 0, 0);
    while (1)
      {
        hit = GetMouseClick(&x,&y,&buttons);
	Delay(4, 4);
	if (buttons==7)
	  {
	    DeleteVGT(vgt,1);
	    DeleteSDF(sdf);
	    return;
	  }
      }
    
  }


MouseTest()
  {
     File *test, *in, *OpenPad();
     SystemCode err;
     short buttons, x, y;
     char c;

     printf("Mouse test\n");
     Flush(stdout);
     test = OpenPad( "Test", 48, 80, &err );
     if (test==NULL)
       {
         printf("Error %s opening the pad\n", ErrorString(err) );
         return;
       }
     in = OpenFile( test->fileserver, test->fileid, FREAD, &err );
     if (in==NULL)
       {
         printf("Error %s opening the input\n", ErrorString(err) );
	 Close(test);
       }
      fprintf( test, "This is printed on the new pad\n");
      fprintf( test, "Press the buttons, all three to exit:");
      Flush(test);
      ModifyPad(test, ReportTransition);
      while (1)
        {
          buttons = GetMouseEvent(test,&x,&y,NULL);
	  if (buttons>=0)
              printf("You are at x=%d, y=%d, buttons=%d\n",x,y,buttons);
	   else
	      printf("You are out of the VGT\n");
	  Flush(stdout);
	  RedrawPad(stdout);
	  Delay(0,10);
          if (buttons==7) break;
	}      
      fprintf( test, "\r\n Now Click somewhere:");
      Flush(test);
      ModifyPad(test, ReportClick);
      buttons = GetMouseEvent(test,&x,&y,NULL);
      printf("You clicked at x=%d, y=%d, buttons=%d\n",x,y,buttons);
      RedrawPad(test);
      Close(test);
   }


StatusTest()
  {
     File *test, *in, *OpenPad();
     SystemCode err;
     short buttons, x, y;
     char c;

     printf("Mouse test\n");
     Flush(stdout);
     test = OpenPad( "Test", 48, 80, &err );
     if (test==NULL)
       {
         printf("Error %s opening the pad\n", ErrorString(err) );
         return;
       }
     in = OpenFile( test->fileserver, test->fileid, FREAD, &err );
     if (in==NULL)
       {
         printf("Error %s opening the input\n", ErrorString(err) );
	 Close(test);
       }
      fprintf( test, "This is printed on the new pad\n");
      fprintf( test, "Move the mouse around, end with all buttons down:");
      Flush(test);
      ModifyPad(test, ReportClick);
      while (1)
        {
          buttons = GetMouseStatus(test,&x,&y,NULL);
	  if (buttons>=0)
	    {
	      short line, col;
	      PadFindPoint(0,48,x,y,&line,&col);
              /** printf("You are at x=%d, y=%d, buttons=%d\n",x,y,buttons);
	        **/
	      fprintf(test,"\033[%d;%dH%d",line,col,buttons);
	      Flush(test);
              RedrawPad(test);
	    }
	   else
	     {
	      printf("You are out of the VGT\n");
	      Flush(stdout);
              RedrawPad(stdout);
    	      Delay(0,10);
	    }
          if (buttons==7) break;
        }
      RedrawPad(test);
      Close(test);
   }

Quit() {exit();}

ZapTest()
  {
    File f;
    
    f.fileserver = stdout->fileserver;
    f.fileid = 3145;
    RedrawPad(&f,0);
  }
