/*
 * openpad.c - routines to open files pointing to pads
 *
 * Bill Nowicki February 1983
 */

# include <Vioprotocol.h>
# include <Vtermagent.h>

extern File *_Open();

File *OpenPad(name, lines, columns, error)
  char *name;
  short lines, columns, *error;
  {
    CreateInstanceRequest req;
    
    if (name==NULL) name = "Unknown";
    req.requestcode = CREATE_INSTANCE;
    req.filenamelen = strlen(name);
    req.filenameindex = 0;
    req.filename = name;
    req.type = 0;
    req.unspecified[0] = lines;
    req.unspecified[1] = columns;
    req.unspecified[2] = 0;       /* important, see OpenAndPositionPad */
    return( _Open(&req, FCREATE|FRELEASE_ON_CLOSE, 
    	GetPid(VGT_SERVER, LOCAL_PID), error) );

  }

typedef struct
  {
    unsigned		fillA[ 2 ];
#ifndef LITTLE_ENDIAN
    short	lines;
    short	columns;
    short	x;
    short	y;
#else   LITTLE_ENDIAN
    short	columns;
    short	lines;
    short	y;
    short	x;
#endif  LITTLE_ENDIAN
    unsigned	flag;	/* very important, distinguishes
			 * between OpenPad and OpenAndPositionPad */
    unsigned	fillB[ 3 ];
  } CreateInstanceUnspecifiedFields;

File *OpenAndPositionPad( name, x, y, lines, columns, error )
  char *name;
  short x, y, lines, columns;
  short *error;
  {
    CreateInstanceRequest req;
    CreateInstanceUnspecifiedFields *unspecified =
	(CreateInstanceUnspecifiedFields *) (&req);
    
    if (name==NULL) name = "Unknown";
    req.requestcode = CREATE_INSTANCE;
    req.filenamelen = strlen(name);
    req.filenameindex = 0;
    req.filename = name;
    req.type = 0;
    unspecified->lines = lines;
    unspecified->columns = columns;
    unspecified->x = x;
    unspecified->y = y;
    unspecified->flag =
	( CREATE_INSTANCE ^ req.unspecified[ 0 ] ^ req.unspecified[ 1 ] );
    return( _Open(&req, FCREATE|FRELEASE_ON_CLOSE, 
    	GetPid(VGT_SERVER, LOCAL_PID), error) );

  }


SelectPad(file)
 File *file;
  {
  	/*
	 * Selects the given pad for input
	 */
    IoRequest msg;
    msg.requestcode = (SystemCode)SwitchInput;
    msg.fileid = file->fileid;
    Send( &msg, file->fileserver );
  }

ModifyPad(file,mode)
    File *file;
  {
  	/*
	 * Set the mode for the indicated file
	 */
    struct ModifyMsg msg;
    
    msg.requestcode = ModifyPadRequest;
    msg.fileid = file->fileid;
    msg.mode = mode;
    Send( &msg, file->fileserver );    
  }

QueryPad(file)
    File *file;
  {
  	/*
	 * Query the mode for the indicated file
	 */
    struct ModifyMsg msg;
    
    msg.requestcode = QueryPadRequest;
    msg.fileid = file->fileid;
    Send( &msg, file->fileserver );    
    return(msg.mode);
  }

QueryPadSize(file, lines, columns)
    File *file;
    short *lines;
    short *columns;
  {
  	/*
	 * Query the mode for the indicated file
	 */
    struct ModifyMsg msg;
    
    msg.requestcode = QueryPadRequest;
    msg.fileid = file->fileid;
    Send( &msg, file->fileserver );    
    *lines = msg.lines;
    *columns = msg.columns;
    return(msg.mode);
  }
