/* 'Field' package.
 * GetField, DisplayFields, PutField, StrToFormat
 * EditField, ReadStdFld, EditStdFld
 *
 * allows you to use 'pad' as a menu and a form.
 *
 * (c) Per Bothner November 1983
 */
#include <Vio.h>
#include <Vtermagent.h>
#include <Vgts.h>
#include "fields.h"
typedef struct
  {
    int width, precision;
    int bits;			/* special options */
    int type;			/* conversion type letter */
    char *start;		/* beginning of format in unparsed form */
    int fLength;		/* length of format in unparsed form */
  } ParsedFormat;

/* Possible values for 'ParsedFormat'.bits */
#define AlignLeft 1
#define Short 2
#define Long 4
#define ZeroFill 8

static char *
ParseFormat(format, s)
    register ParsedFormat *format; register char *s;
    /* parse format string 's' and return 'format' */
  { int b = 0, type, i;
    format->start = s;
    s++;	/* skip '%' */
    if (*s == '-') { b |= AlignLeft; s++;}
    if (*s == '0') { b |= ZeroFill; s++;}
    for (i = 0; *s >= '0' && *s <= '9';) { i = i*10 + *s-'0'; s++;}
    format->width = i;
    if (*s == '.') s++;
    for (i = 0; *s >= '0' && *s <= '9';) { i = i*10 + *s-'0'; s++;}
    format->precision = i;
    if (*s == 'l' || *s == 'L') { b |= Long; s++;}
    if (*s == 'h' || *s == 'H') { b |= Short; s++;}
    type = *s++;
    if (type >= 'A' && type <= 'Z') {b |= Long; type += 'a'-'A';}
    format->bits = b;
    format->type = type;
    format->fLength = s - format->start;
    return s; 
  }

static
PutUntilConversion(buffer, format)
    register char **buffer, **format;
  { register char ch, *s = *buffer, *f = *format;
    while (ch = *f++)
      {
	if (ch == '%')
	    if (*f == '%') f++;
	    else {f--; break;}
	*s++ = ch;
      }
    *s = 0; *buffer = s; *format = f;
    return ch;
  }

#define OutputMode 1
static char *FormatFormat(fBuf, format, mode)
 /* Inverse to ParseFormat: convert a ParsedFormat structure to a string */
    char *fBuf;
    register ParsedFormat *format;
    int mode;
  {
    FILE *fad = OpenStr(fBuf, 50, NULL);
    if (fad == NULL) return NULL;
    fputc('%', fad);
    if (format->bits & AlignLeft) fputc('-', fad);
    if (format->bits & ZeroFill) fputc('0', fad);
    if (format->width != 0) fprintf(fad, "%d", format->width);
    if (format->precision != 0) fprintf(fad, ".%d", format->precision);
    if (mode & OutputMode) { }
    else if (format->bits & Long) fputc('l', fad);
    else if (format->bits & Short) fputc('h', fad);
    fputc(format->type, fad);
    fputc(0, fad);
    fclose(fad);
    return fBuf;
  }

static
SpecialSprintf(buf, f, value)
    char *buf;  ParsedFormat *f; int *value;
 /* like sprintf, but f is a ParsedFormat, and value must be dereferenced */
  {
    char fBuf[50];
    int i = f->fLength - 1;
    if (FormatFormat(fBuf, f, OutputMode) == NULL) return;
    if (f->bits & Short)
      {
	sprintf(buf, fBuf, *(short *)value);
      }
    else if ((f->bits & Long) 
        && (f->type == 'f' || f->type == 'g' || f->type == 'e'))
      {
	sprintf(buf, fBuf, *(double *)value);
      }
    else if (f->type == 's')
      {
	sprintf(buf, fBuf, value);
      }
    else sprintf(buf, fBuf, *value);
  }

PutField(buffer, field)
    char *buffer; Field *field;
  { char *s = field->format; ParsedFormat f;
    if (PutUntilConversion(&buffer, &s))
      {
	s = ParseFormat(&f, s);
	SpecialSprintf(buffer, &f, field->value);
	if (*s) sprintf(buffer + strlen(buffer), s);
      }
  }

Field *
GetField(menu, menuLength, buttons, pad)
    Field *menu; short buttons;
    File *pad;
  {
    short row, col, oldrow = -1, oldcol = -1, oldButtons = buttons, x, y;
    short nrows, ncols;
    char buffer[140];
    register Field *entry=0, *oldentry=0;
    int mode = QueryPadSize(pad, &nrows, &ncols), i;
    ModifyPad(pad, ReportTransition+NoCursor);
    if (!buttons)
      { char cBuf[30];
	if (GetEvent(pad, &x, &y, &oldButtons, cBuf) || oldButtons == 0)
	  {
	    ModifyPad(pad, mode);
	    return 0;
	  }
      }
    while (oldButtons==(buttons=GetGraphicsStatus(pad,&x,&y,0)))
      {
        PadFindPoint(pad, nrows, x, y, &row, &col);
	col++; /*bug in PadFindPoint*/
	if (col != oldcol || row!=oldrow)
	  { i = menuLength;
	    for(entry = menu; ; entry++)
	      {
		if (entry->row < 0 || --i < 0) {entry = 0; break;}
		if (row == entry->row && col >= entry->col 
		  && col < entry->col + entry->width)
		    break;
	      }
	    if (entry != oldentry)
	      {
		if (oldentry)
		    fprintf(pad, "\033[%d;%dH%.*s",
			oldentry->row, oldentry->col, oldentry->width,
			buffer);
		if (entry)
		  {
		    PutField(buffer, entry);
		    fprintf(pad, "\033[%d;%dH\033[1m%.*s\033[0m",
			entry->row, entry->col, entry->width, buffer);
		  }
		Flush(pad); RedrawPad(pad);
	        oldentry = entry;
	      }
	  }
	Delay(0, 5);
      }
    if (entry)
      {
        fprintf(pad, "\033[%d;%dH%.*s",
	    entry->row, entry->col, entry->width, buffer);
        if (buttons)
	  {
	    entry = 0;
	    while (GetGraphicsStatus(pad,&x,&y,0) > 0) Delay(0, 5);
	  }
      }
    ModifyPad(pad, mode);
    Flush(pad);
    return entry;
  }

DisplayFields(menu, menuLength, pad)
    Field *menu;
    File *pad;
  { char buffer[140];
    register int n = menuLength; register Field *entry = menu;
    for ( ; --n >= 0 && entry->row >= 0; entry++)
      {
	fprintf(pad, "\033[%d;%dH", entry->row, entry->col);
	PutField(buffer, entry);
	fprintf(pad, "%s", buffer);
      }
    Flush(pad);
  }

EditStdFld(field)
    Field *field;
  {
    return EditField(field, 1, stdout, stdin);
  }

ReadStdFld(field)
    Field *field;
  {
    return EditField(field, 0, stdout, stdin);
  }

EditField(field, stuff, out, in)
    Field *field; 
    int stuff; /* 0 if old text should be cleared, 1 if stuff into editor */
    File *out, *in;
  { char ch, *s = field->format, format[20], buffer[140], *t = buffer;
    int oldLen, mode = QueryPad(in), i; ParsedFormat f;

    ModifyPad(in, LineBuffer+Echo+LF_Output+CR_Input);
    /* first position the cursor */
    fprintf(out, "\033[%d;%dH", field->row, field->col);
    oldLen = PutUntilConversion(&t, &s);
    if (!oldLen) 
      {
	ModifyPad(out, mode);
        return -1;
      }
    fprintf(out, "%s", buffer);
    /* put old data part of field in buffer */
    ParseFormat(&f, s);
    SpecialSprintf(buffer, &f, field->value); 
    oldLen = strlen(buffer);
    /* get new input */
    if (f.type=='g'||f.type=='e') f.type = 'f';
    if (f.bits & Long)
        if (f.type == 's')
	    sprintf(format, "%%%d[^\n\r]",
		f.precision > 0 ? f.precision : 140);
	else sprintf(format, "%%l%c",f.type);
    else if (f.bits & Short) sprintf(format, "%%h%c",f.type);
    else if (f.type == 's' && f.precision > 0)
	sprintf(format, "%%%ds", f.precision);
    else sprintf(format, "%%%c",f.type);
    if (!stuff)
      {
	fprintf(out, "\033[%dP\033[%d@", oldLen, oldLen);   /* erase old */
	oldLen = 0;
	Flush(out);
      }
    else
      {
        Flush(out);
        EditLine(out, buffer, oldLen);
      }
    if (fscanf(in, "%140[^\007\n\r]", buffer) < 1) *buffer = 0;
    ch = fgetc(in);
    ModifyPad(in, mode);
    if (ch == '\007' /* BELL */) i = -1;
    else i = sscanf(buffer, format, field->value);

    /* fix display -- at this point, whatever was to the right of the field
     * on the same line has been pushed to the right (line editing is in
     * insert mode) by oldLen - strlen(buffer) characters, so we go fix
     * that up
     */
    oldLen -= strlen(buffer);
    fprintf(out, "\033[%d;%dH", field->row, field->col + field->width);
    if (oldLen > 0) fprintf(out, "\033[%d@", oldLen);
    else if (oldLen < 0) fprintf(out, "\033[%dP", -oldLen);
    DisplayFields(field, 1, out); /* redisplay in "standard" format */
    return i;
  }

char *
StrToFormat(f, s, n)
    register char *f, *s;
 /*
  * Copy string s to f (which is at least n bytes). '%' is doubled,
  * so that f when used as a format, yields s.
  */
    register n;
  { register char ch, *f0 = f;
    while (--n > 0)
      {
	ch = *s++;
	if (ch == '%')
	    {if (--n <= 0) break; *f++ = '%';}
	*f++ = ch;
	if (!ch) return f0;
      }
    *f = 0; return f0;
  }
