/* 
 * This routine provides VERY MINIMAL support for the Unix signal routine.
 * It handles only keyboard interrupts and will probably not work if the
 * interrupt routine tries returning to the main program.  It is intended
 * for programs which want to clean up (e.g. delete temporary files) and
 * then exit when the user types control-C.
 */

#include <Vio.h>
#include "/usr/include/signal.h"
#include "/usr/include/errno.h"

static int (*Catcher)();
static ProcessId Watcher;

static WatchForBreak(), Meditate();

int (*signal(sig, func))()
  int (*func)();
  {
    static int (*oldcatcher)() = SIG_DFL;
    extern int errno;

    /* For now, ignore anything other than ^C and ^\ */
    if (!(sig == SIGINT || sig == SIGQUIT))
	return SIG_DFL;

    oldcatcher = Catcher;
    Catcher = func;
    
    if (!Watcher || !ValidPid(Watcher))
      {
        Watcher = Create(1, WatchForBreak, 1000);
	if (!Watcher)   /* Give error if can't create process */
	{
	    errno = ENOMEM; /* Not really right but have to give some error */
	    return BADSIG;;
	}
	Ready(Watcher, 0);
      }
  }

static WatchForBreak()
  {
    static breakPid = 0;
    Message msg;
    
    for(;;)
      {
	if (!breakPid || !ValidPid(breakPid))
	  {
	    breakPid = Create(1, Meditate, 400);
	    if (!breakPid)
	        Suicide();
	    Ready(breakPid, 0);
	  }
	SetBreakProcess(stdin, breakPid);
    
	ReceiveSpecific(msg, breakPid);
    
	(*Catcher)();
      }
  }

static Meditate()
  {
    Message msg;
    
    Receive(msg);
  }
