# Input: a list of filenames, one per line
# Output: the same list, with all but the first of duplicate filenames
#	(where a filename is the LAST component of the path and ignores
#	the filetype suffix) removed.
BEGIN {FS="/"}
    { 
	i = split ( $NF, tmp, "." );
	mumble = substr($NF, 1, length($NF) - length(tmp[i]) - 1);
	list[mumble] ++ ;
	if (list[mumble] == 1)
	    print;
    }
