/* Minimal keyboard input function */
#define wordchar(c) (((c >= 'a') && (c <= 'z')) || ((c >= 'A') && (c <= 'Z')))
#define BackSpace() {p--; puts("\b \b");}

unsigned char *gets(string)
unsigned char *string;
  {
    register unsigned char c, *p = string;

    for (;;)
      {
	switch (c = (K_getchar() & 0x7f))
	  {
	    case '\b':		/* Backspace */
	    case 0x7f:		/* Delete */
		if (p == string) continue;
		BackSpace();
		break;
	
	    case ('U'&0x1F):	/* ^U */
		while (p != string) BackSpace();
		break;

#ifdef LOTS_OF_ROOM 		/* The uVaxen have lots of room. */
	    case ('W'&0x1f):	/* ^W */
		if (p == string) continue;
	    /* Back up over non-word characters preceeding the prev. word. */
		while ((p != string) && !wordchar(*(p-1))) BackSpace();
		/* Back up over prev. word. */
		while ((p != string) && wordchar(*(p-1))) BackSpace();
		break;
#endif LOTS_OF_ROOM

	    case '\r':
	    case '\n':
		*p = '\0';
		K_putchar('\n');
		return(string);

	    default:
		K_putchar((c<' ') ? 0x7 : (*p++ = c)); /* Bell or echo char */
	  }
      }
  }
