/*
 * crt0.s:  Initial entry point for V standalone programs.  Does MicroVAX-
 *	    specific initialization, then calls _Vsasu (basic V initialization)
 *	    which finally calls _main.
 *  This code is #ifdef'ed to include or exclude, independently:
 *	- a basic interrupt- and exception-handler (if INITINTS is defined)
 *	- a copy of DEC's debugger, xdelta	   (if XDELTA   is defined)
 *  Normally we produce two versions: crt0.o has INITINTS, and xdeltacrt0.o has
 *  both INITINTS and XDELTA.
 *
 *  We always allocate 8K of stack space immediately after the end of bss,
 *  and initialize the stack and frame pointers appropriately.  Woe betide
 *  the unsuspecting programmer whose standalone program uses more than 8K
 *  of stack space.
 *
 *  We need to create and initialize a System Control Block; we ignore 
 *  (probably overwrite) the one created by the MicroVAX bootstrap ROM.
 *  The SCB is allocated after the stack.  When we're using xdelta, we ignore
 *  the SCB allocated within the xdelta binary - it's more trouble than it's
 *  worth to ensure that it's page-aligned.
 *
 *  SCB use:
 *    - INITINTS initializes all vectors in the SCB:  The timer interrupt
 *      (IPL 16, SCB+0xC0) increments a counter; all others print a possibly
 *      helpful message and exit(0).
 *    - XDELTA alters the vectors for trace pending (SCB+0x28), 
 *	breakpoint (SCB+0x2C) and software interrupt level 5 (SCB+0x94).
 *  Thus we call initints first (if at all), followed by xdelta's 
 *  initialization routine (ditto); the standalone program itself comes last.
 *
 *  Other things done by crt0.s:
 *  - point the Process Control Block Base register somewhere harmless -
 *    after the end of the SCB.  Under some circumstances, such as switching
 *    from the interrupt stack to the kernel stack, the MicroVAX II writes back
 *    some register values to the PCB.  By default the PCBB is 0, and we end
 *    up clobbering code.  Since (see below) we no longer change to kernel 
 *    mode, this may not actually occur, but it's nice to feel safe.
 *  - The MicroVAX I, and probably II, bootstraps leave the processor running
 *    on the interrupt stack rather than the kernel stack.  Once upon a time
 *    someone (Maslen) thought that being on the interrupt stack wrought havoc
 *    with some instructions, and so we went through some contortions to
 *    change to the kernel stack.  This seems to be unnecessary, so the code
 *    is still present but #ifdef'ed out.
 *  - initialization for particular processor types:
 *      For the MicroVAX I, clear "boot in progress" flag (otherwise sundries
 *	  such as auto reboot and halt don't behave as expected).
 *      For the MicroVAX II, clear "boot in progress" and "restart in progress"
 *	  software flags and set halt mode.
 */

#include "ipl.hdr"

	.text
	.globl	_start		/* Normal entry point for program after boot*/
	.globl	__start		/* The C compiler for the MicroVAX knows    */
				/*   that, by default, the entry point of a */
				/*   program is the C symbol _start (i.e.   */
				/*   __start is generated by the compiler). */
				/* We keep _start for compatibility only.   */

/* External symbols: */
#ifdef XDELTA
	.globl	_dbg$init
	.globl	_dbg$break
	.globl	_xdt$fault
#endif XDELTA
#ifdef INITINTS
	.globl	_initints
#endif INITINTS



#ifdef  XDELTA
	.globl	restart		/* A hook for debugging sessions that bomb  */
restart:			/* Put this at the start so it has an easily*/
				/* remembered address (probably 0 or 0x3000)*/
	jmp	_xdt$fault	/* Well, it will have an easily remembered  */
				/* address only if xdeltacrt0.o is loaded   */
				/* first, or xdelta (12K) is loaded first,  */
				/* followed immediately by xdeltacrt0.o     */
#endif XDELTA

_start:
__start:
	moval	_end+8192,sp	/* Allocate 8K stack space.  Vsasu.c knows  */
	movl	sp,fp		/*   this too - ugh.			    */

	addl3	sp, $0x1FF, r0	/* Put SCB on next page boundary after stack */
	bicl2	$0x1FF, r0
	mtpr	r0,$scbb

	addl2	$1024, r0	/* And point the PCBB somewhere harmless */
	mtpr	r0,$pcbb	/*   (immediately after the SCB)	 */

#ifdef undef	/* Maybe we can run on the interrupt stack now */
	/* If we're on the interrupt stack then change to the kernel stack  */
	movpsl	-(sp)
	bbcc	$(psl$v_is % 8), (psl$v_is / 8)(sp), not_i
	pushal	chm_done	/* Build a fake REI frame ("saved" PSL, PC) */
	moval	8(sp), r0	/* Initialize the Kernel Stack Pointer;	    */
	mtpr	r0, $ksp	/*   value = (value of SP at chm_not_i)	    */
	rei			/* REI:  mode = kernel, jumps to chm_done   */
not_i:
	addl2	$4,sp		/* get rid of pushed psl */
chm_done:
#endif

	mfpr	$sid, r0	/* Extract processor type from System ID reg*/
	ashl	$-24, r0, r1
	caseb	r1, $7, $1      /* Can't use an expression for the length;  */
				/*   breaks the Unix assembler		    */
case_start:
	.word	uvax1_init - case_start	/* 07xxxxxx -> MicroVAX I	    */
	.word   uvax2_init - case_start /* 08xxxxxx -> MicroVAX II, despite */
					/*   what the documentation says    */
	brb	no_perproc_init		/* Don't know processor type; assume*/
					/* no special initialization needed */
uvax1_init:
	mtpr	$txdb_clear_boot_flag, $txdb
	brb	no_perproc_init
uvax2_init:
	movl	$0x200B801C, r0		/* Console Program Mailbox Register */
					/*   - N.B. not virtual address	    */
	bicb3	$0xC, (r0), r1		/* Clear "Restart in Progress",	    */
					/*       "Boot in Progress".	    */
	bisb3	$0x3, r1, (r0)		/* Halt action = 3, i.e. don't try  */
					/*   restart or reboot, just "halt".*/
no_perproc_init:

#ifdef INITINTS
	calls	$0,_initints	
#endif INITINTS
#ifdef XDELTA
	mfpr	$scbb, -(sp)	/* dbg$init(scbb) - note that we use the SCB*/
	calls	$1, _dbg$init	/*  provided by the bootstrap, not xdelta's */
	jsb	_dbg$break	/* Execute a breakpoint before starting Vsasu*/
#endif XDELTA
				/* Push arguments for _Vsasu:		    */
	pushl	r11		/*   arge = addr of Restart Parameter Block */
	pushal	4(ap)		/*   argv = bootstrap argument list	    */
	movzwl	(ap), -(sp)	/*   argc = length of argument list	    */
	calls	$3, _Vsasu
#ifdef XDELTA
	jsb	_dbg$break	/* And another breakpoint before halting    */
#endif XDELTA
	halt

/*
*	The exit routine.  Prints the exit status and then halts or
*	goes into the debugger.
*/
	.text
	.align	1
	.globl	_exit
_exit:
	.word	0x0
	.data
L44:
	.ascii	"Exited with a status of %d\0"
	.text
	pushl	4(ap)
	pushl	$L44
	calls	$2,_printf
#ifdef XDELTA
	jsb	_dbg$break
#endif XDELTA
	halt
