#include <Vio.h>
#include "process.h"

#define STACK_SIZE 8192

extern end, edata;
unsigned char FakeBuf;

static File InFile = 
  {
    &FakeBuf,		/* current byte position */
    &FakeBuf,		/* do not read past here */
    &FakeBuf,		/* do not write past here */
    NULL,		/* Next FAD in list */
    0,			/* Instance id for the file */
    0,			/* Server process for instance */
    0,			/* Internal state of FAD */
    OK,			/* Last exception code set */
    0,			/* File type attributes */
    1,			/* Maximum in bytes to read or write */
    0,			/* Current block number */
    0,			/* Last block */
    0,			/* Last bytes */
    &FakeBuf,		/* Buffer ptr */
    0			/* Size of current block */
  };

static File OutFile = 
  {
    &FakeBuf,		/* current byte position */
    &FakeBuf,		/* do not read past here */
    &FakeBuf,		/* do not write past here */
    NULL,		/* Next FAD in list */
    0,			/* Instance id for the file */
    0,			/* Server process for instance */
    0,			/* Internal state of FAD */
    OK,			/* Last exception code set */
    0,			/* File type attributes */
    1,			/* Maximum in bytes to read or write */
    0,			/* Current block number */
    0,			/* Last block */
    0,			/* Last bytes */
    &FakeBuf,		/* Buffer ptr */
    0			/* Size of current block */
  };

Process TheProcess;
Process *Active = &TheProcess;
static PerProcessArea PPA =
  {
    &InFile, &OutFile, &OutFile,
    {0, 0},
    STACK_SIZE,
    "",
    NULL,
    NULL
  };
PerProcessArea *PerProcess = &PPA;
File *TeamFileList = NULL;

ProcessId Kernel_Process_Pid = 0xffffffff;
    
#ifdef undef
char InterruptStack[1024];

asm("	.text");
asm("	.align	1");
asm("	halt");
asm("	.globl	_start");
asm("_start:");
asm("	moval	_InterruptStack, sp");
asm("	addl2	$1024, sp");
asm("	mtpr	sp, $4");
asm("	movl	sp, fp");
asm("	calls	$0, _Vsasu");
asm("	halt");
#endif

Vsasu() /* called from _start() (in crt0.s) */
  {
    Zero(&edata, &end-&edata);
    GiveToMalloc(&end + STACK_SIZE, STACK_SIZE);
    stdin = &InFile;
    stdout = &OutFile;
    stderr = stdout;
    K_puts("Starting standalone program.\n");
    EnetPowerup();
    main();
  }

nevercalled()
  {
    /* kludge to make sure that these routines are pulled in */
    GetMoreMallocSpace(0,0);
    MakeHexDigit();
  }
