/*
 * NameSend() and GetContextId()
 *
 * NameSend() is used to send off a naming protocol request using
 *  the naming cache in the standard way.  It accepts the message to
 *  be sent as its argument.  As with Send, NameSend returns
 *  the pid of the replier, and modifies its argument to contain the first
 *  reply message received.  The caller can invoke GetReply() upon
 *  return if additional replies are anticipated.
 *
 * Warning: the string passed in the request message must be null-terminated;
 *  req->namelength is neither examined nor set by this routine.
 */

#include "Vnaming.h"
#include "Vgroupids.h"
#include "Vnamecache.h"

/*forward*/ SystemCode GetContextId();

ProcessId NameSend(req)
    register NameRequest *req;
  {
#   define reply ((ContextReply *) req)
    register NameCacheEntry *ce = NULL;
    register char *p;
    ContextPair context;
    register startindex, relname = 0;
    register ProcessId replier;
    Message msg;
    register ContextRequest *qreq = (ContextRequest *) msg;
#   define qreply ((ContextReply *) msg)	    
    SystemCode err;
    NameRequest savereq;

    /* Save original message in case of retries */
    savereq = *req;

retry:
    p = &req->nameptr[req->nameindex];
    if (p[0] == ROOT_ESCAPE_CHAR)
      {
        /* An absolute name.  Strip root escape character and use
	 * the root context. */
	p++;
	context.pid = VCSNH_SERVER_GROUP;
	context.cid = GLOBAL_ROOT_CONTEXT;
      }
    else
      {
	/* A relative name.  Just use the current context. */
	relname = 1;
	context = PerProcess->ctx;
      }

    req->nameindex = p - req->nameptr;
    req->namecontextid = context.cid;
    replier = Send(req, context.pid);

    switch (reply->replycode)
      {
        case KERNEL_TIMEOUT:
	case NONEXISTENT_PROCESS:
	case INVALID_CONTEXT:
	case NOT_HERE:
	      if (relname)
	        {
		  /* Try remapping the current context
		   *  If we get a different result this time, maybe that
		   *  will fix the problem.
		   */
		  err = GetContextId(PerProcess->ctxname, &context);
		  if (  err == OK && 
		       !ContextPairEqual(context, PerProcess->ctx) )
		    {
		      PerProcess->ctx = context;
		      *req = savereq;
		      goto retry;
		    }
		}	

      }
    return replier;
#undef reply
#undef qreply
  }


/*
 * getcontextid.c
 *
 * Function-call interface to GET_CONTEXT_ID message.  Interprets the 
 *   given name in the current context and returns a corresponding
 *   serverpid/contextid pair.
 */
#include "Vnaming.h"

SystemCode GetContextId(name, context)
    char *name;
    ContextPair *context;
  {
    Message msg;
    register ContextRequest *req = (ContextRequest *) msg;
    register ContextReply *reply = (ContextReply *) msg;
    ProcessId pid;

    req->requestcode = GET_CONTEXT_ID;
    req->nameindex = 0;
    req->nameptr = name;
    req->namelength = strlen( name );

    /* Interpret the given name in the current context */
    NameSend(req);

    if (reply->replycode != OK) return (reply->replycode);

    /* Return context identifier */
    *context = reply->context;

    return (OK);
  }
