/*
 * Distributed V Kernel 
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 *
 * Inter kernel communication routines
 * Minimal set needed for standalone bootstrap loader,
 *   hacked up to run in busy-wait mode (TPM 11/11/83)
 * Partly based on a similar hack done for SGI
 *
 */

#include "process.h"
#include <Vikc.h>
#include <Vethernet.h>
#include <Vioprotocol.h>
#include <Vgroupids.h>
#include <Venviron.h>

#define	MAXTRANS		5
#define MAX_PACKET_DELAY	50

#ifdef DEBUG
#define debug(c) K_putchar(c)
#else
#define debug(c)
#endif DEBUG

extern Process *Active;

unsigned short userNumber = UNKNOWN_USER;
unsigned short 	CurrentSeqNo = 1;
extern kPacket	*kPacketSave;
extern SystemCode AwaitKernelPacket();
int PacketDelay;  /* number of packets not for us received since last
		   *   good packet in AwaitSendReply */

#define CopyMsg(to, from) Copy(to, from, 32)

ProcessId Send( msg, pid ) 
    register MsgStruct *msg;
    ProcessId pid;
  {
    register Process *pd, *prev;
    unsigned append;
    int WriteKernelPacket();
    SystemCode r;

debug('{');
    /* Adjust process state */
    pd = Active;
    CopyMsg(&pd->msg, msg);

    /* Check if there is segment associated with this message */
    if ( msg->sysCode & SEGMENT_PRESENT )
      {
        pd->dataSegmentPro = 
		(unsigned char)(msg->sysCode >> 8 );
        pd->dataSegmentPtr = (Unspec *) (msg->segmentPtr);
        pd->dataExpected = NULL;
        pd->dataSegmentSize = msg->segmentSize;
      }
    else
        pd->dataSegmentSize = 0;

    pd->forwarder = ( Process * ) pd->pid;
    pd->blocked_on = pid;
    pd->seqNo = CurrentSeqNo++;
    pd->state = AWAITING_REPLY;
    /* Send off packet */
    pd->numTrans = 0;
    while ( ++(pd->numTrans) < MAXTRANS )
      {
        if( (pd->dataSegmentPro & READ_ACCESS) &&
	    (pd->dataSegmentSize > 0 ) )
          {
	    if( pd->dataSegmentSize >= MAX_APPENDED_SEGMENT )
	        append = MAX_APPENDED_SEGMENT;
	    else
	        append = pd->dataSegmentSize;
	    WriteKernelPacket(remoteSend,pd->pid,pid,0,append,0,
		     	 NULL,pd->seqNo,msg,pd->dataSegmentPtr);
          }
        else
	    WriteKernelPacket(remoteSend,pd->pid,pid,0,0,NULL,
			 NULL,pd->seqNo,msg,NULL);
	if ( AwaitSendReply() == OK ) break;  /* got a reply */
debug('~');
      }
    if (pd->numTrans == MAXTRANS)
      {
	msg->sysCode = TIMEOUT;
debug('T');
      }
    else
	CopyMsg(msg, &pd->msg);		/* succeeded */

debug('}');
    return (pd->blocked_on);
  }

AwaitSendReply()
    /*
     * Busy wait, looking for a reply to a Send.
     * Also handle MoveTo/MoveFrom requests while waiting.
     */
  {
    extern kPacket *kPacketSave;
    ProcessId pRemoteReply();
    ProcessId pBreathOfLife();
    ProcessId pRemoteMoveFromReq();
    ProcessId pRemoteMoveToReq();
    ProcessId pRemoteReceiveSpecific();
    ProcessId pRemoteForward();
    ProcessId pRemoteSend();

    PacketDelay = 0;
    for (;;)
      {
	if (AwaitKernelPacket() != OK) return (TIMEOUT);

#ifdef undef
debug('0' + kPacketSave->packetType);
K_putchar(' ');
puthex(kPacketSave->srcPid >> 16);
K_putchar('-');
puthex(kPacketSave->srcPid);
K_puts(" -> ");
puthex(kPacketSave->dstPid >> 16);
K_putchar('-');
puthex(kPacketSave->dstPid);
K_puts("\n");
#endif

        switch (kPacketSave->packetType)
	  {

	  case remoteSend:
	    pRemoteSend();
	    break;

	  case remoteReply:
	    pRemoteReply();
	    if (Active->state == READY) return (OK);
	    break;

	  case breathOfLife:
	     pBreathOfLife();
	     break;

	  case remoteMoveFromReq:
	    pRemoteMoveFromReq();
	    break;

	  case remoteMoveToReq: 
	    pRemoteMoveToReq();
	    break;

	  case remoteReceiveSpecific:
	    pRemoteReceiveSpecific();
	    break;
	    
	  case remoteForward:
	    pRemoteForward();
	    break;

	  }
        if( PacketDelay++ > MAX_PACKET_DELAY ) 
          {
debug('t');
	    return( TIMEOUT );
	  }
      }
  }

ProcessId pRemoteForward()
  {
    register Process *pd;
    register kPacket *kp = kPacketSave;

    /* Adjust process state */
    pd = Active;
    if ( (kp->dstPid != pd->pid) || (kp->sequenceNo != pd->seqNo) ) return;

    CopyMsg( &pd->msg, &kp->msg );
    pd->blocked_on = kp->forwarder;
    pd->forwarder = ( Process * ) pd->pid;
    pd->numTrans = 0;
    WriteKernelPacket(remoteSend,pd->pid,pd->blocked_on,0,NULL,0,
	 NULL,pd->seqNo,&pd->msg,pd->dataSegmentPtr);
  }


/* Put on our KernelServer hat and handle a few random kernel requests */
ProcessId pRemoteSend()
  {
    KernelRequest rep;
    register KernelRequest *reply = &rep;
    register kPacket *kp = kPacketSave;

#define req ((KernelRequest *) &kp->msg)

    if ( (kp->dstPid == (Active->pid & 0xffff0000) + 0x4000) &&
	 (req->pid == Active->pid) )
      {
	reply->opcode = OK;
	reply->length = 0;
	reply->segment = NULL;

	switch ( req->opcode )
	  {
	    case QUERY_PROCESS:
	    reply->pid = Active->pid;
	    break;

	    case SET_USER_NUMBER:
	    userNumber = req->length;
	    reply->opcode = OK;
	    break;

	    default:
	    reply->opcode = DISCARD_REPLY;
	  }
	if (reply->opcode != DISCARD_REPLY)
	    WriteKernelPacket(remoteReply, kp->dstPid, kp->srcPid,
		  0, 0, NULL, NULL, kp->sequenceNo, reply, NULL);
      }
#undef req
  }

/* To pick up the server's replies */
ProcessId pRemoteReply()
  {
    register Process *pd;
    register kPacket *kp = kPacketSave;

    pd = Active;

    if ( ( pd->pid != kp->dstPid ) || ( pd->seqNo != kp->sequenceNo ) )
	return;

    pd->blocked_on = kp->srcPid;
    pd->state = READY;
    CopyMsg( &pd->msg, &kp->msg );
    if( kp->length != 0 )
      {
	if( ((pd->dataSegmentPro & WRITE_ACCESS) == 0 ) ||
	    ((unsigned)pd->dataSegmentPtr > (unsigned)kp->remoteaddress)||
	    ((unsigned)kp->remoteaddress+kp->length >
	     (unsigned)pd->dataSegmentPtr+pd->dataSegmentSize) )
	    DiscardDataPacket( kp->length );
	else
	    ReadDataPacket( kp->length, kp->remoteaddress );  
      }
    return;
  }


/* Server might send this */
ProcessId pBreathOfLife()
  {
    register kPacket *kp = kPacketSave;
    register Process *pd = Active;

    if ( ( pd->pid == kp->dstPid ) && ( pd->seqNo == kp->sequenceNo ) )
      {
	pd->numTrans = 0;
	PacketDelay = 0;
      }
  }

 
/* The Vserver implements ValidPid by sending out remoteReceiveSpecific
 * packets. The kernel does a QueryProcessState on the pid that it's
 * interested in. For now we don't handle that case.
 */
ProcessId pRemoteReceiveSpecific()
  {
    register kPacket *kp = kPacketSave;

    if ( kp->dstPid == Active->pid )
        WriteKernelPacket ( breathOfLife,kp->dstPid,kp->srcPid,0,0,NULL, 
			NULL,kp->sequenceNo,NULL,NULL );
  }

ProcessId pRemoteFoward()
  {
    register Process *pd = Active;
  }
/* In case the server needs to retrieve a filename */
ProcessId pRemoteMoveFromReq()
  {
    Process *pd, *active;
    register kPacket *kp = kPacketSave;
    int WriteKernelPacket();
    int lengthLeft;
    register unsigned error = 0;

    pd = Active;

#ifdef undef
if (pd->pid != kp->dstPid)
    error |= 1;
if (pd->state != AWAITING_REPLY)
    error |= 2;
if ((pd->dataSegmentPro & READ_ACCESS) == 0)
    error |= 4;
if ((unsigned)pd->dataSegmentPtr > (unsigned)kp->remoteaddress)
    error |= 8;
if  ((unsigned)kp->remoteaddress+kp->length > 
	  (unsigned)(pd->dataSegmentPtr)+pd->dataSegmentSize)
    error |= 16;
    if (error)
      {
        K_putchar('[');
	puthex(error);
	K_putchar(']');
	return;
      }
#endif

    if ( (pd->pid != kp->dstPid) ||
         (pd->state != AWAITING_REPLY) ||
	 ((pd->dataSegmentPro & READ_ACCESS) == 0) ||
         ((unsigned)pd->dataSegmentPtr > (unsigned)kp->remoteaddress) ||
         ((unsigned)kp->remoteaddress+kp->length > 
	  (unsigned)(pd->dataSegmentPtr)+pd->dataSegmentSize) )
        return;

    pd->numTrans = 0;	/* Reset transmissions counter */
    PacketDelay = 0;
    lengthLeft = kp->length;
    while (lengthLeft > MAX_APPENDED_SEGMENT)
      {
        WriteKernelPacket(remoteMoveFromReply,kp->dstPid,kp->srcPid,
		  0,MAX_APPENDED_SEGMENT,kp->length,
		  kp->localaddress,kp->sequenceNo,NULL,kp->remoteaddress);
        kp->localaddress = (Unspec *)((unsigned)(kp->localaddress) 
		+ MAX_APPENDED_SEGMENT);
        kp->remoteaddress = (Unspec *)((unsigned)(kp->remoteaddress) 
		+ MAX_APPENDED_SEGMENT);
	lengthLeft -= MAX_APPENDED_SEGMENT;
      }
    if( lengthLeft != 0 )
      {
        WriteKernelPacket(remoteMoveFromReply,kp->dstPid,kp->srcPid,
		  0, lengthLeft,kp->length,
		  kp->localaddress,kp->sequenceNo,NULL,kp->remoteaddress);
      }
  }
   

/* This allows the server to load stuff into our memory */
ProcessId pRemoteMoveToReq()
  {
    Process *pd, *active;
    register kPacket *kp = kPacketSave;
    int ReadDataPacket(), DiscardDataPacket();
    /* kp->remoteaddress is a local address,
       kp->localaddress is the total length */

    pd = active = Active;
    if ( (pd->pid != kp->dstPid) ||
	 (pd->state != AWAITING_REPLY) ||
	 ((pd->dataSegmentPro & WRITE_ACCESS) == 0) ||
	 (kp->remoteaddress < pd->dataSegmentPtr) ||
         ((unsigned)kp->remoteaddress+kp->length > 
	  (unsigned)(pd->dataSegmentPtr)+pd->dataSegmentSize) )
      {
debug('#');
        DiscardDataPacket( kp->length );
        return;
      }

    pd->numTrans = 0; /* Reset transmission counter */
    PacketDelay = 0;

    /* Sequencing check */
    if( pd->dataExpected == NULL ||		/* new MoveTo group */
	kp->sequenceNo != pd->seqNoExpected ||
        kp->remoteaddress < pd->remoteSegmentPtr )
      {
	pd->seqNoExpected = kp->sequenceNo;
        pd->remoteSegmentPtr = pd->dataExpected = kp->remoteaddress;
        pd->remoteSegmentSize = (unsigned) kp->localaddress;
      }

    if( kp->remoteaddress == pd->dataExpected )
      {
        pd->dataExpected = (Unspec *)((unsigned)pd->dataExpected+kp->length);
        ReadDataPacket( kp->length, kp->remoteaddress );

        /* Check if done */
        if((unsigned)pd->dataExpected ==
	   (unsigned)pd->remoteSegmentPtr + pd->remoteSegmentSize)
	  {
	    pd->dataExpected = NULL;
	    WriteKernelPacket(remoteMoveToReply,kp->dstPid,kp->srcPid,
			      0,pd->remoteSegmentSize,pd->remoteSegmentPtr,
			      NULL,kp->sequenceNo,NULL,NULL);
  	  }
      }
    else
      {
debug('?');
        DiscardDataPacket( kp->length );
      }
  }

ProcessId GetPid ( logical_id, scope )
register unsigned logical_id;
  {
    KernelRequest msg;
    register KernelRequest *req = &msg;

    req->opcode = GET_PID;
    req->pid = 0;
    req->unspecified[0] = logical_id;
    req->unspecified[1] = scope;
    Send( req, VKERNEL_SERVER_GROUP );
    if ( req->opcode != OK ) return( 0 );
    return( req->pid );
  }

