
#include <Vio.h>

unsigned RealFillBuffer();
RealFlushBuffer();

static EchoFlag = 1;
static CookedFlag = 1;
int stdinBufferIndex = 0;
int stdinBufferCount = 0;
char stdinBuffer[128];

NoEcho() { EchoFlag = 0; }
Echo() { EchoFlag = 1; }
int IsEcho() { return(EchoFlag); }

Cooked() { CookedFlag = 1; }
Raw() { CookedFlag = 0; }
int IsCooked() { return(CookedFlag); }

#define wordchar(c) (((c >= 'a') && (c <= 'z')) || ((c >= 'A') && (c <= 'Z')))
#define control(c) (c & 0x1f)
#define BackSpace() {p--; K_putchar('\b'); K_putchar(' '); K_putchar('\b');}

char RawGetchar()
  {
    register int c;
    
    while ((c = K_mayget()) == -1);
    return(c & 0xff);
  }

GetBufferedLine()
  {
    register char c;
    register char *p = stdinBuffer;
    register char *start = stdinBuffer;

    for (;;)
      {
	switch (c = (RawGetchar() & 0x7f))
	  {
	    case '\b':		/* Backspace */
	    case 0x7f:		/* Delete */
		if (p == start) continue;
		if (!IsEcho()) p--; else BackSpace();
		break;
	
	    case ('U'&0x1f):	/* ^U */
		if (!IsEcho()) p = start; while (p != start) BackSpace();
		break;

	    case ('W'&0x1f):	/* ^W */
		if (p == start) continue;
		if (!IsEcho()) { K_putchar(7); continue; }
	    /* Back up over non-word characters preceeding the prev. word. */
		while ((p != start) && !wordchar(*(p-1))) BackSpace();
		/* Back up over prev. word. */
		while ((p != start) && wordchar(*(p-1))) BackSpace();
		break;

	    case '\r':
	    case '\n':
		*p++ = '\n';
		if (IsEcho()) K_putchar('\n');
		stdinBufferIndex = 0;
		stdinBufferCount = p - start;
 		return;

	    default:
		if (c < ' ') K_putchar(7);	/* Bell */
		else
		  {
		    *p++ = c;
		    if (IsEcho()) K_putchar( c );
		  }
	  }
      }
  }

unsigned FillBuffer(fad)
File *fad;
  {
    register char c;
    if (fad == stdin)
      {
        if (stdinBufferIndex < stdinBufferCount)
	    return(stdinBuffer[stdinBufferIndex++]);
	if (CookedFlag)
	  {
	    GetBufferedLine();
	    return(stdinBuffer[stdinBufferIndex++]);
	  }
	c = RawGetchar();
	if (IsEcho()) K_putchar( c );
	return( c );
      }
    
    return( RealFillBuffer(fad) );
  }

FlushBuffer(fad, byte)
File *fad;
char byte;
  {
    if (fad == stdout || fad == stderr) return(K_putchar(byte));
    
   return( RealFlushBuffer(fad, byte) );
  }

RealFlushBuffer( fad, byte)
    register File *fad; char byte;
 
    /* Flush the buffer of the open file specified by fad, and put the
     * byte in the now empty buffer.
     */
 
  {
    if (fad->state & EOF_BYTE)
        return EOF;

    /* If not writeable, complain */
    if (!(fad->type & WRITEABLE))
      {
        fad->state |= EOF_BYTE;
	fad->lastexception = NOT_WRITEABLE;
	return EOF;
      }

    /* Validate buffer, if possible */
    Seek( fad, 0, REL_BYTE );
    if( fad->state & EOF_BYTE )  return EOF;

    /* Get ready to write */
    if ((fad->block == fad->lastblock) && (fad->type & FIXED_LENGTH))
        fad->writeLimit = fad->buffer + fad->lastbytes;
    else
    	fad->writeLimit = fad->buffer + fad->blocksize;

    if( fad->current < fad->writeLimit )
        return *(fad->current)++ = byte;

    /* Current position can't be written */
    fad->state |= EOF_BYTE;
    fad->lastexception = END_OF_FILE;
    return EOF;
  }

#define BufferValid(fad) \
	( fad->currsize != MAXUNSIGNED || \
	  fad->writeLimit > fad->buffer && fad->current > fad->buffer )

unsigned RealFillBuffer( fad )
    register File *fad;

   /* Fill the buffer of the open file specified by fad. Return the first
    * character in the buffer or EOF.
    */

   {
      if( fad->state & EOF_BYTE )   return( EOF );

      /* Questionable  hack */
      if ((fad == stdin) && (stdout->type & INTERACTIVE))
	Flush(stdout); /* Flush standard output */

     /*
      * If file is VARIABLE_BLOCK and this was a short block, advance
      *  past the nonexistent part at the end.  In either case, try to
      *  read the current (normalized) block.
      */
      if ( (fad->type&(VARIABLE_BLOCK|READABLE))==(VARIABLE_BLOCK|READABLE) &&
      	   BufferValid(fad) )
          Seek( fad, fad->block + 1, ABS_BLK);
      else
          Seek( fad, 0, REL_BYTE );

      if( fad->state & EOF_BYTE )   return( EOF );	/* Seek failed */

      /* Return the next byte */
      if( fad->current < fad->readLimit )
        return *fad->current++;
      
      /* Error: even after seeking, we didn't manage to get to a valid
       *  position.  This means either we are beyond the end of file,
       *  or the file was not readable. (Or we advanced into a zero-length
       *  block within a variable-block file!  That case is punted for now.)
       */
      fad->state |= EOF_BYTE;
      if (fad->type & READABLE) 
          fad->lastexception = END_OF_FILE;
      else
          fad->lastexception = NOT_READABLE;
      return( EOF );
   }

