/*
 * rawio2.c: Version of rawio.c (q.v.) which uses routines in the MicroVAX II
 *           Console ROM to do console I/O.
 *           Hack attack! This file contains #ifndefs and code which is roughly
 *	     equivalent to that in rawio.c.  Unless the #ifndefs are disabled, each
 *	     routine checks at runtime whether it's on a MicroVAX II.  If so,
 *	     it calls the ROM routines (assumed to be present); otherwise, it
 *	     uses the serial interface much as rawio.c would.
 *
 * Nota Bene: 
 *   (0) This will die horribly on any system which claims to be a MicroVAX II
 *	 but doesn't have the (correct) console ROM.
 *   (1) This does not implement K_mayget, since - as far as we know - there
 *       isn't a ROM routine we can call for this.
 *   (2) The ROM routines only work when memory mapping is disabled.  There's
 *	 some pretty awful crocks in here that check whether memory mapping is
 *	 enabled and, if so, try to turn it off, call the ROM routine, and
 *	 turn it back on, all without screwing up the calling program.  See
 *	 below for the fairly extreme assumptions these make about the calling
 *	 program.
 *   (3) The ROM reserves some pages at the end of memory for its use.  These
 *	 must be left intact by the calling program, or the ROM will object.
 *	 Currently (8-Dec-85) the V kernel stomps on these pages - this should
 *	 be changed for a variety of reasons.
 *   (4) The DEC memo on which these is based warns:
 *       "NOTE THAT THIS SUPPORT IS NOT DOCUMENTED FOR CUSTOMER USE AND MAY BE
 *       CHANGED WITHOUT NOTICE."
 * Given all these problems, it may be more intelligent to write our own
 * routines and ignore the ROM.  However, the ROM routines are nicely 
 * tailored to the hardware: they know about the QVSS and the console serial
 * port, and can switch between them without bothering us.
 *
 * Internals.  There are three routines we've been told about:
 *   JSB *$0x20050008
 *      Function: Get character (waits for input, doesn't echo)
 *      In      : R0 bits 0..15 specify timeout.  0 means no timeout.
 *      Out     : R0 bits 0..7  return the character
 *		  R0 bits 8..15 return I/O status bits that we ignore
 *      Destroys: R0, R1 only.
 *   JSB *$0x2005000C
 *      Function: Put String
 *      In      : R0 is address of string descriptor (see below), and must be
 *                greater than 0x1FF - otherwise it is interpreted as a DEC
 *                message code instead of an address.
 *      Out     : none
 *      Destroys: R0, R1 only.
 *      Notes   : Only knows about carriage return, line feed - no other 
 *                control characters.
 *   JSB *$0x20050010
 *      Function: Read with prompt
 *      In      : R0 is address of string descriptor for prompt - see above
 *                for restrictions.
 *                R1 bits 0..15 timeout, as for Get Character.
 *      Out     : R0 bits 0..15 is number of bytes read
 *                R1 is the address of the input string
 *      Destroys: R0, R1 only.
 *      Notes   : Input characters are stored in the Console ROM's very own
 *                buffer (somewhere) - the address of this is returned.
 *                The input routine knows about RUBOUT, ^U (Return with byte
 *		  count = 0) and ^R (redisplay current input buffer, keep
 *		  editing).
 *		  Maximum length of input buffer is 80 bytes.
 *		  At present we don't use this routine at all.
 *   String descriptors look like:
 *     .word byte_count - number of bytes in string 
 *			  (strings are NOT zero-terminated)
 *     .word 0		- ignored.  Officially it contains two bytes that
 *			  identify this as a string descriptor, but in practice
 *			  noone cares.
 *     .long address    - address of first byte of string.
 *
 * All these routines use the QVSS (and its keyboard) by default, but 
 * automagically switch to the serial line (and keyboard) if there doesn't 
 * seem to be a QVSS or the user asked to change to the serial line 
 * (by sending a BREAK on the serial line).
 */

#include "ipl.h"
#define disable	asm("	mtpr	$0x1f,	$ipl");
	/* Disable ALL interrupts.  We don't use the kernel's version of */
	/* 'disable' because it currently (28-Mar-86) quite deliberately */
	/* sets the ipl to 0x15 so that timer interrupts can still be    */
	/* processed; we can't allow that here because we're monkeying   */
	/* with the stack.						 */

asm("	.globl	ROM2_GetChar");
asm("	.set	ROM2_GetChar   , 0x20050008");
asm("	.globl	ROM2_PutString");
asm("	.set	ROM2_PutString , 0x2005000C");
asm("	.globl	ROM2_ReadPrompt");
asm("	.set	ROM2_ReadPrompt, 0x20050010");

int Our_stack[256]; /* Says he, picking a random number */
char End_stack;	    /* Dummy variable to give address of stack's bottom */

/*
 * K_mayget: Doesn't exist.  We don't know of a ROM routine which does this,
 *	     and it's no use just having the version from rawio.c.  This way,
 *	     anyone who refers to K_mayget will get a link-time error, which
 *	     seems to be the best we can do.
 *
 * If we really felt we needed this (e.g. for netwatch), we could try to:
 *   - call ROM2_GetChar with r0 = FFFF.  It turns that r0 is a timeout value
 *     and the zero we normally pass means infinity.  Because of the way the
 *     ROM I/O routines are coded, it will still execute the inner 
 *     check/timeout loop 4124 (?) times before it notices that the timeout
 *     count is negative
 *   - call one of the ROM routines we've heard about, but isn't supported
 *     even as much as the above three.
 */

/*
 * K_putchar: prints the character c on the console (QVSS or serial line)
 */
K_putchar( c )
    int c;
  {
    /*
     * HORRIBLE HACK: Filter out ^G, since the MicroVAX II ROM displays it on
     *   the QVSS as ^G, which does us no good at all.  Heaven help the person
     *   who actually wants to send a ^G.  If the MicroVAX II is ever given
     *   the gift of speech (or at least a bell) and software to drive it,
     *   this should be abolished.
     */
    if (c == '\007')
	return;
    if (c == '\n')
      {
	/* rawio.c had delay loops before and after \r.  Do we need them? */
	K_putchar('\r');
      }
    ; /* This semicolon ensures that the compiler generates a branch to the */
      /*   correct place (here), not somewhere later in the code.	    */
#ifndef MVAX_II_ONLY
    asm("	mfpr	$sid, r0");
    asm("	ashl	$-24, r0, r0");
    asm("	cmpb	r0, $8");/* 0x08 = MicroVAX II */
    asm("	bneq	K_putchar_use_console");
#endif  MVAX_II_ONLY
    asm("	mfpr	$mapen, r0");
    asm("	blbs	r0, K_putchar_unmap");
				 /* If MAPEN = 0, then just ....	    */
    asm("	pushal	4(ap)"); /* Build a string descriptor backwards on  */
asm("	bicl2	$0x80000000, (sp)");
    asm("	pushl	$1");    /* the stack - hope stack pointer > 1FF    */
asm("	bicl2	$0x80000000, sp");
    asm("	movl	sp, r0");
    asm("	jsb	*$ROM2_PutString");
    asm("	ret");
				/* MAPEN = 1; turn it off temporarily.	    */
				/* ***** ASSUMES that this code is mapped so*/
				/* that it will keep running even when we   */
				/* turn mapping off.  True for the V kernel */
				/* at present, since virt. 80000000+x --> x */
    asm("K_putchar_unmap:");
    asm("	movb	4(ap), r0");
				/* Get the character from its virtual addr  */
    asm("	mfpr	$ipl, r1");
    disable;
    asm("	movl	$_End_stack, sp");
				/* Set the sp to a physical address.  Don't */
				/* save it first, since we can regenerate it*/
				/* from fp				    */
asm("	bicl2	$0x80000000, sp");
    asm("	mtpr	$0, $mapen");
#ifdef LIVE_DANGEROUSLY
    asm("	mtpr	r1, $ipl");
				/* Can we really process an interrupt when  */
				/* we're running unmapped, and everything in*/
				/* the kernel assumes mapped addresses?     */
#else
    asm("	pushl	r1");
#endif
    asm("	movzbl	r0, -(sp)");
    asm("	pushal	(sp)"); /* Build a string descriptor backwards on   */
    asm("	pushl	$1");   /* the stack - hope stack pointer > 1FF     */
    asm("	movl	sp, r0");
    asm("	jsb	*$ROM2_PutString");
#ifdef LIVE_DANGEROUSLY
    asm("	mfpr	$ipl, r1");
    disable;
#else
    asm("	movl	12(sp), r1");
#endif
    asm("	mtpr	$1, $mapen");
    asm("	movl	fp, sp");
    asm("	mtpr	r1, $ipl");
#ifndef MVAX_II_ONLY
    asm("	ret");
    asm("K_putchar_use_console:");
    asm("	mfpr	$txcs, r1");
    asm("	bitb	$0x80, r1");
    asm("	beql	K_putchar_use_console");
    asm("	movzbl	4(ap), r0");
    asm("	mtpr	r0, $txdb");
    /* rawio.c waits until RDY (txcs & 0x80) is true again.  Why? */
#endif  MVAX_II_ONLY
  }

/*
 * K_getchar: busy wait for character (no echo)
 */
K_getchar()
  {
#ifndef MVAX_II_ONLY
    asm("	mfpr	$sid, r0");
    asm("	ashl	$-24, r0, r0");
    asm("	cmpb	r0, $8");
    asm("	bneq	K_getchar_use_console");
#endif  MVAX_II_ONLY
    asm("	mfpr	$mapen, r0");
    asm("	blbs	r0, K_getchar_unmap");
				/* If MAPEN = 0, then just ....	    */
    asm("	clrw	r0");
    asm("	jsb	*$ROM2_GetChar");
    asm("	brb	K_getchar_mung");
				/* MAPEN = 1; turn it off temporarily.	    */
				/* ***** ASSUMES that this code is mapped so*/
				/* that it will keep running even when we   */
				/* turn mapping off.  True for the V kernel */
				/* at present, since virt. 80000000+x --> x */
    asm("K_getchar_unmap:");
    asm("	mfpr	$ipl, r1");
    disable;
    asm("	movl	$_End_stack, sp");
				/* Set the sp to a physical address.  Don't */
				/* save it first, since we can regenerate it*/
				/* from fp (in fact, the RET will do it)    */
    asm("	mtpr	$0, $mapen");
#ifdef LIVE_DANGEROUSLY
    asm("	mtpr	r1, $ipl");
				/* Can we really process an interrupt when  */
				/* we're running unmapped, and everything in*/
				/* the kernel assumes mapped addresses?     */
#else
    asm("	pushl	r1");
#endif
    asm("	clrw	r0");
    asm("	jsb	*$ROM2_GetChar");
#ifdef LIVE_DANGEROUSLY
    asm("	mfpr	$ipl, r1");
    disable;
#else
    asm("	movl	(sp)+, r1");
#endif
    asm("	mtpr	$1, $mapen");
    asm("	movl	fp, sp");
    asm("	mtpr	r1, $ipl");
#ifndef MVAX_II_ONLY
    asm("	brb	K_getchar_mung");
    asm("K_getchar_use_console:");
    asm("	mfpr	$rxcs, r1");
    asm("	bitb	$0x80, r1");
    asm("	beql	K_getchar_use_console");
    asm("	mfpr	$rxdb, r0");
    asm("	bitw	$0xff00, r0");
    asm("	beql    1f");
    asm("	mnegl	$1, r0");
    asm("	ret");
    asm("1:");
#endif  MVAX_II_ONLY
    asm("K_getchar_mung:");
    asm("	bicl2	$~0x7F, r0");
    asm("	cmpb	$0x0D , r0");
    asm("	bneq	2f");
    asm("	movb	$0x0A , r0");
    asm("2:");
  }

/*
 * K_puts: K_putchar's a complete string
 *
 * We simply pass the string character-by-character to K_putchar, and leave
 *   K_putchar to do any character munging (\n -> \r\n).
 */
K_puts( str )
    char *str;
  {
    register char c;

    while (c = *str++) K_putchar(c);
  }
