/*
 * rawio.c
 *
 * This used to be fakeemt.c, the Fake Emulator Trap package for SMI Suns,
 * but now there is a logical separation of mc680x0 machines and SUNs.
 * Thus, the functionality that the old fakeemt routines afforded us is
 * preserved, only they have been made machine independent.  For example,
 * where PutChar (from machine.c) used to just call emt_putchar, which did
 * a "(*RomVecPtr->v_getchar)()", we now have K_putchar, which does what is
 * appropriate to get a character, according to what kind of machine for
 * which it is compiled ( Sun-1, Sun-2, mc68010 Firefly, Nebula, etc. ).
 */

#include "sunromvec.h"

/* Allocation for RomVecPtr and initialization to to SUN1_ROM_VEC_PTR.
 * If we are compiling the kernel for a sun2, the value of RomVecPtr is changed
 * to SUN2_ROM_VEC_PTR so that the prom is mapped to the proper location.
 * This is done in the Init_memory_mapping routine of sun2mem.c.
 */
struct sunromvec *RomVecPtr = (struct sunromvec *) SUN1_ROM_VEC_PTR;

/*
 * K_getchar:
 * Kernel version of getchar.
 * Returns character read from console keyboard.
 */
char K_getchar()
  {
    return( ( *( RomVecPtr->v_getchar ) )() );
  }

/*
 * int K_mayget()	-- returns character read from console keyboard,
 *			   or -1 if none are queued
 */
int K_mayget()
  {
    return( ( *( RomVecPtr->v_mayget ) )() );
  }


/*
 * K_putchar:
 * Kernel version of putchar.
 * Prints character c on Console.
 */
K_putchar(c)
    char c;
  {
    return( ( *( RomVecPtr->v_putchar ) )(c) );
  }

/*
 * K_puts:
 * Kernel version of puts.
 * Prints string str on Console.
 * "Output a string busy wait on the console from the kernel."
 */
K_puts( str )
    register char *str;
  {
    register char c;

    while( c = *str++ ) K_putchar( c );
  }


/*
 * int K_getconfig()	-- returns processor board configuration
 */
int K_getconfig()
  {
    return( -1 );	/* no config register -- make it appear all 1's */
  }


/*
 * int K_getmemsize()	-- returns on-board memory size in bytes
 */
int K_getmemsize()
  {
    return( *( RomVecPtr->v_MemorySize ) );
  }


/*
 * int K_ticks()	-- returns milliseconds since monitor booted
 */
int K_ticks()
  {
    return( *( RomVecPtr->v_RefrCnt ) );
  }


/*
 * int K_version()	-- returns monitor version number
 */
int K_version()
  {
    return( *( RomVecPtr->v_SunRev ) );
  }

/*
 * fbmode(mode) -- sets/queries monitor's frame buffer mode:
 *
 * INPUT:	flag = 1 or -1 => set FB mode to flag (unless FBmode == 0)
 *		flag = <other>	=> no side effects
 * OUTPUT:	1 = using FB
 *		0 = no fb present
 *		-1 = fb present but not in use
 *		
 */

fbmode(mode)
    int mode;
  {
    return( 1 );
  }
