
#include <Venviron.h>

extern ProcessId Kernel_Process_Pid;

SystemCode SetProcessPriority(pid, priority, decay)
    ProcessId pid;
    unsigned short priority;
    unsigned decay;
  {
    KernelRequest request;
    register KernelRequest *req = &request;
    
    req->opcode         = SET_PROCESS_PRIORITY;
    req->pid            = pid;
    req->unspecified[0] = (unsigned)priority;
    req->unspecified[1] = decay;

    Send(req, Kernel_Process_Pid);

    return(req->opcode);
  }

unsigned short QueryProcessPriority(pid)
    ProcessId pid;
  {
    KernelRequest request;
    register KernelRequest *req = &request;
    
    req->opcode = QUERY_PROCESS_PRIORITY;
    req->pid    = pid;

    Send(req, Kernel_Process_Pid);

    return( (req->opcode == OK) ? (unsigned short)req->unspecified[0] : 0 );
  }
