/* #define NAMING_STATS */

#include <Vteams.h>
#include <Vmachine.h>

#ifdef NAMING_STATS
#include <Vnamecache.h>    
extern NamingStats NS;
static ReportNamingStats();
#endif NAMING_STATS

extern SystemCode ForceSend();

exit( status )
    register int status;
  /*
   * Close all team files and send to the creator of the team
   * requesting termination.
   */
  {
    extern ProcessId TeamCreator;
    extern File *TeamFileList;
    Message msg;
    register ExitTeamRequest *req = (ExitTeamRequest *) msg;
    ProcessId pid;
    register File *file;
    SystemCode err;

    /* Close all team files */
    while( TeamFileList ) Close( TeamFileList );

#ifdef NAMING_STATS
    ReportNamingStats(&NS, LNAMING_STATS_GROUP);    
#endif NAMING_STATS

    pid = GetTeamRoot(GetPid(ACTIVE_PROCESS, LOCAL_PID));
    req->requestcode = TERMINATE_TEAM;
    req->requestType = SpecificTeam;
    req->rootPid = pid;
    req->status = status;

    if (TeamCreator)
      {
        err = ForceSend( req, pid, TeamOwner(pid));
        abort("exit: ForceSend returned %z", err);  /* just in case. */
      }
     else
      /*
       * Return to the monitor if this is the "system" team.
       */
       { RETURN_TO_MONITOR;}
  }


#ifdef NAMING_STATS

static ReportNamingStats(ns, pid)
    NamingStats *ns;
    ProcessId pid;
  {
    NamingStatsRequest req;
    unsigned long clicks;

    req.requestcode = ADD_STATS;
    req.time = GetTime(&clicks) * CLICKS_PER_SEC;
    req.time += clicks;
    req.statbuf = ns;
    req.bufsize = sizeof(NamingStats);
    Send(&req, pid);
  }
    
#endif NAMING_STATS
