/*
 * Copyright (c) 1983 by David Cheriton, Willy Zwaenepoel, Lance Berc
 * V Kernel Interface
 *
 * 	DestroyProcess
 */

#include "Venviron.h"
#include "Vgroupids.h"

SystemCode DestroyProcess( id )
    register ProcessId id;
  {
    Message msg;
    KernelRequest *req = (KernelRequest *) msg;
    SystemCode r;
    ProcessId serverid;
    extern Process_id Kernel_Process_Pid;

repeat_destroy:
    req->opcode = DESTROY_PROCESS;
    req->pid = id;
    serverid = Kernel_Process_Pid;

    if( IsLocalGroupId(id) )
	serverid = (id & LOGICAL_HOST_PART) | LKERNEL_SERVER_GROUP;
    else if( IsGlobalGroupId(id) )
	serverid = VKERNEL_SERVER_GROUP;

    Send( req, serverid );

    r = req->opcode;
    if( IsGroupId(id) )
      {
	while( (r == OK) && GetReply(req, 20) ) r = req->opcode;

	/* Make sure that all processes in the group have been destroyed */
	if( r == OK )
	 { 
	    req->opcode = QUERY_GROUP;
	    req->pid = 0;
	    req->unspecified[0] = id;
	    Send( req, VKERNEL_SERVER_GROUP );
	    if ((req->opcode != NOT_FOUND) && (req->opcode != KERNEL_TIMEOUT))
		 goto repeat_destroy;
	  }
       }
    return( r );
  }

