/*
 * destroy.c
 *
 * Destroy(pid)				--Destroy pid and free stack
 * Suicide()				--Same as Destroy(0)
 *
 */

#include <Vio.h>
#include <Vprocess.h>

SystemCode Destroy(pid)
    ProcessId pid;
  {
    Processor_state state;
    register PerProcessArea *ppa;
    SystemCode r;

    /* Find per process area if on the same team */
    if ( SameTeam(0, pid) && 
         ReadProcessState(pid, &state) != 0 )
      {
	ppa = (PerProcessArea *) state.perProcess;
      }

    if (pid != 0 && pid != GetPid(0, 0))
      {
        r = DestroyProcess(pid);
        if (r != OK) return r;
      }
    else
        r = RETRY;	/* Flag for deferred DestroyProcess, in case we are */
			/* committing suicide				    */

    if (ppa != NULL)
      {
	if (ppa->ctxname != NULL) free(ppa->ctxname);
	free(ppa);
      }

    return (r == OK ? OK : DestroyProcess(pid));
  }


Suicide()
  {
    /* Abort if Destroy(0) returns */ 
    abort("Suicide failed: %z", Destroy(0));
  }
