/*
 * ready.c
 *
 * DESCRIPTION
 * The Ready function sets up the stack so that the child process looks
 * like it got called with the specified arguments.  It also sets things
 * up so that if the child ever returns, it calls Suicide.
 *
 * EXPORTS
 * Ready(pid, n, a1, ..., an)		--Start it running
 *
 * IMPORTS
 * malloc, various kernel primitives
 * Suicide
 *
 * AUTHOR
 * Tim Mann
 *
 * HISTORY
 * 03/12/82 TPM - Initial version
 * 04/16/85 JHS - separated it from create.c, which is machine independent.
 */

#include "Vio.h"
#include "Vprocess.h"

/* Ready:
 *
 * Sets up arguments on a newly created process's stack, and adds
 *  the process to the ready queue by replying to it.  Returns zero
 *  if the process couldn't be replied to.
 * The first argument is the process id, the second is a count of
 *  the number of arguments to be passed to the child process, and
 *  the third and following contain the arguments.
 */
/* VARARGS2 */
Ready(child, nargs, firstarg)
ProcessId child;
short nargs;
long firstarg;
  {
    Processor_state childState;
    long *stackPtr;
    int Suicide();
    Message msg;
    long *argp;
    
    if (ReadProcessState(child, &childState) == 0) return (0);
    stackPtr = (long *) childState.USER_STACK_POINTER;

    /* Stack up the arguments */
    argp = &firstarg + nargs;
    for ( ; nargs>0 ; nargs--)
      {
	*--stackPtr = *--argp;
      }

    /* Arrange for the child to destroy itself
     *  if it falls off the end of its code */
    *--stackPtr = (long) Suicide;

    childState.USER_STACK_POINTER = (Unspec) stackPtr;
    if (WriteProcessState(child, &childState) == 0) return (0);

    /* Reply to it */
    ((MsgStruct *) msg)->sysCode = OK;
    if (Reply(msg, child) == 0) return(0);

    return (child);

  }

