|
| _start.s
|
| Assembly code to get a new team started off on the right foot.
|
| The initial team space layout is:
|   | code | data | bss | istack | TEB |
| where	code=	program code space
|       data=	initialized data
|	bss=	uninitialized data (actually initialized to 0, in this code)
|	istack=	initial stack space; used for the root stack
|		until the TEB has been unpacked.
|	TEB=	team environment block; contains the command line args,
|		environment variables, etc.
|
| This assembly code points the stack into the istack space, calls
|   TeamRoot to initialize the standard I/O and unpack the TEB,
|   then resets the stack to the size called for by RootStackSize,
|   and finally calls main().  If main() returns s, we call exit(s).
|
| The team layout when it starts execution is:
|   | code | data | bss | root stack | heap |
| The root process's PerProcess area is at the start of its stack, as
|   with all PerProcess areas.

_INIT_STACK_SIZE = 1024

	.data
BssCleared:
	.word	0	| flag indicating whether bss has already been cleared

	.text
	.globl	_start
_start:

| First, clear the frame pointer
|
	movl	#0, a6

| Second, fetch the root message.
|
	movl	#_RootMsg, a5
	moveml	#/07F8, a5@

| Temporarily position the stack pointer at _end + _INIT_STACK_SIZE so we
|   are using only the small istack area, to be sure the stack doesn't
|   smash the TEB or go past the end of our team space.
|
	movl	#[_end + _INIT_STACK_SIZE], sp

| Zero the bss segment
|
	tstw	BssCleared	| Check if program was dumped
	bne	1$
	movl	#_end, d0	| Should be computable at link time
	subl	#_edata, d0
	movl	d0, sp@-
	movl	#_edata, sp@-
	jbsr	Zero		| Zero(ptr, n)
	addql	#8, sp
	addqw	#1, BssCleared	| Don't do it next time (if there is one)

| Call TeamRoot() to do the rest of the setup
|
1$:
	jbsr	TeamRoot

| Move the end of the stack where it belongs
|
	movl	#_end, sp
	addl	RootStackSize, sp

| Call main(argc, argv)
|
	movl	Argv, sp@-
	movl	Argc, sp@-
	jbsr	main
	addql	#8, sp

| Call exit if main returns
|
	movl	d0, sp@-	| use return from main as arg to exit
	jbsr	exit
	addql	#4, sp

| Die with a privilege violation if exit() returns -- it isn't supposed to!
|
	stop	#0
