/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Stack manipulation package.
 *
 * Marvin Theimer, 11/25/83
 *	First written.
 */


#include <Vio.h>
#include "package.h"

extern char *malloc();




/*
 * NOTE:
 * The stack consists of a header record which points at a singly-linked list
 * of stack element records.
 */


char *InitStack()
  {
    GenHdrRec *stack;

    stack = (GenHdrRec *) malloc(sizeof(GenHdrRec));
    stack->head = NULL;
    return((char *)stack);
  }


int EmptyStack(stack)
    GenHdrRec *stack;
  {
    if (stack->head == NULL)
      {
	return(TRUE);
      }
    else
      {
	return(FALSE);
      }
  }


PushStack(stack, item)
    GenHdrRec *stack;
    GenRec *item;
  {
    item->next = stack->head;
    stack->head = item;
  }


GenRec *PopStack(stack)
    GenHdrRec *stack;
  {
    GenRec *tmp;

    tmp = stack->head;
    if (tmp != NULL)
      {
	stack->head = tmp->next;
        tmp->next = NULL;
      }
    return(tmp);
  }
