/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Singly-linked list manipulation package.
 *
 * Marvin Theimer, 11/25/83
 *	First written.
 */


#include <Vio.h>
#include "package.h"

extern char *malloc();




/*
 * NOTE:
 * The list consists of a header record which points at the the first
 * item record in the list and item records which have next pointers
 * linking themselves together.  The end of the list is delimited by a NULL
 * next pointer.
 */


char *InitSList()
  {
    GenHdrRec *list;

    list = (GenHdrRec *) malloc(sizeof(GenHdrRec));
    list->head = NULL;
    list->tail = NULL;
    return((char *)list);
  }


int EmptySList(list)
    GenHdrRec *list;
  {
    if (list->head == NULL)
      {
	return(TRUE);
      }
    else
      {
	return(FALSE);
      }
  }


AddSList(list, loc, item)
    GenHdrRec *list;
    GenRec *loc;		/* loc points to item AFTER which to insert.
				   loc == list implies insert at front. */
    GenRec *item;
  {
    item->next = loc->next;
    loc->next = item;
    if (item->next == NULL)
      {
	list->tail = item;
      }
  }


GenRec *RemoveSList(list, loc)
    GenHdrRec *list;
    GenRec *loc;		/* loc points to record BEFORE the one to
				   remove.  loc == list implies remove front
				   item of list. */
  {
    GenRec *tmp;

    tmp = loc->next;
    if (tmp == NULL)
      {
	return(NULL);
      }
    if (list->tail == tmp)
      {
        if (loc == (GenRec *)list)
	  {
	    list->tail = NULL;
	  }
	else
	  {
	    list->tail = loc;
	  }
      }
    loc->next = tmp->next;
    tmp->next = NULL;
    return(tmp);
  }


char *FirstSList(list)
    GenHdrRec *list;
  {
    return((char *)list->head);
  }


char *LastSList(list)
    GenHdrRec *list;
  {
    return((char *)list->tail);
  }


/*
 * Iterator used to traverse the list from front to end, using NULL as
 * the termination signal.
 */

char *IterSList(list, loc)
    GenHdrRec *list;
    GenRec *loc;
  {
    return((char *) (loc->next));
  }
