/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Queue manipulation package.
 *
 * Marvin Theimer, 11/25/83
 *	First written.
 */


#include <Vio.h>
#include "package.h"

extern char *malloc();




/*
 * NOTE:
 * The queue consists of a header record which points at a singly-linked list
 * of queue element records.  The header record consists of a head and a tail
 * field.
 */


char *InitQueue()
  {
    GenHdrRec *queue;

    queue = (GenHdrRec *) malloc(sizeof(GenHdrRec));
    queue->head = NULL;
    queue->tail = NULL;
    return((char *)queue);
  }


int EmptyQueue(queue)
    GenHdrRec *queue;
  {
    if (queue->head == NULL)
      {
	return(TRUE);
      }
    else
      {
	return(FALSE);
      }
  }


AddQueue(queue, item)
    GenHdrRec *queue;
    GenRec *item;
  {
    item->next = NULL;
    if (queue->head != NULL)
      {
	queue->tail->next = item;
      }
    else
      {
	queue->head = item;
      }
    queue->tail = item;
  }


GenRec *RemoveQueue(queue)
    GenHdrRec *queue;
  {
    GenRec *tmp;

    tmp = queue->head;
    if (tmp != NULL)
      {
	queue->head = tmp->next;
	if (queue->tail == tmp)
	  {
	    queue->tail = NULL;
	  }
	tmp->next = NULL;
      }
    return(tmp);
  }
