/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Doubly-linked list manipulation package.
 *
 * Marvin Theimer, 11/25/83
 *	First written.
 */


#include <Vio.h>
#include "package.h"

extern char *malloc();




/*
 * NOTE:
 * The list consists of a header record which points to the first item in
 * the list and item records which have next and prev pointers linking
 * themselves together.  The end of the list is delimited by a NULL next
 * pointer.  The first item in the list has a NULL prev pointer.
 */


char *InitDList()
  {
    GenHdrRec *list;

    list = (GenHdrRec *) malloc(sizeof(GenHdrRec));
    list->head = NULL;
    list->tail = NULL;
    return((char *)list);
  }


int EmptyDList(list)
    GenHdrRec *list;
  {
    if (list->head == NULL)
      {
	return(TRUE);
      }
    else
      {
	return(FALSE);
      }
  }


AddDList(list, loc, item)
    GenHdrRec *list;
    GenRec *loc;		/* loc points to item AFTER which to insert.
				   loc == list implies insert at front. */
    GenRec *item;
  {
    item->next = loc->next;
    loc->next = item;
    if (loc == (GenRec *)list)
      {
	item->prev = NULL;
      }
    else
      {
	item->prev = loc;
      }
    if (item->next != NULL)
      {
        item->next->prev = item;
      }
    else
      {
	list->tail = item;
      }
  }


GenRec *RemoveDList(list, loc)
    GenHdrRec *list;
    GenRec *loc;		/* loc points to record to remove. */
  {
    if (loc->next == NULL)
      {
	list->tail = loc->prev;
      }
    if (loc == list->head)
      {
	list->head = loc->next;
	if (loc->next != NULL)
	  {
	    loc->next->prev = NULL;
	  }
      }
    else
      {
	loc->prev->next = loc->next;
	if (loc->next != NULL)
	  {
	    loc->next->prev = loc->prev;
	  }
      }
    loc->next = NULL;
    loc->prev = NULL;
    return(loc);
  }


char *FirstDList(list)
    GenHdrRec *list;
  {
    return((char *)list->head);
  }


char *LastDList(list)
    GenHdrRec *list;
  {
    return((char *)list->tail);
  }


/*
 * Iterator used to traverse the list from front to end, using NULL as
 * the termination signal.
 */

char *IterDList(list, loc)
    GenHdrRec *list;
    GenRec *loc;
  {
    return((char *) (loc->next));
  }
