/*	ldexp.s	4.1	83/06/27	*/

/*
 * double ldexp (value, exp)
 * double value;
 * int exp;
 *
 * Ldexp returns value*2**exp, if that result is in range.
 * If underflow occurs, it returns zero.  If overflow occurs,
 * it returns a value of appropriate sign and largest
 * possible magnitude.
 */

#include "DEFS.h"

/* LSBit of exponent */
#define	EXPSTART	4
/* size in bits of exponent */
#define	EXPWIDE		11
/* Number of bit for mantissa's sign */
#define	EXPSIGN		15
/* 2**EXPWIDE */
#define	EXPSIZE		2048

ENTRY(ldexp)
	movg	4(ap),r0	/* fetch "value" */
	extzv	$EXPSTART,$EXPWIDE,r0,r2	/* r2 := biased exponent */
	jeql	1f		/* if zero, done */

	addl2	12(ap),r2	/* r2 := new biased exponent */
	jleq	2f		/* if <= 0, underflow */
	cmpl	r2,$EXPSIZE	/* otherwise check if too big */
	jgeq	3f		/* jump if overflow */
	insv	r2,$EXPSTART,$EXPWIDE,r0 /* put exponent back in result */
1:
	ret
2:
	clrg	r0
	jbr	1f
3:
	movg	huge,r0		/* largest possible floating magnitude */
	jbc	$EXPSIGN,4(ap),1f	/* jump if argument was positive */
	mnegg	r0,r0		/* if arg < 0, make result negative */
1:
	ret

	.data
huge:	.word	0x7fff		/* the largest number that can */
	.word	0xffff		/*   be represented in a long floating */
	.word	0xffff		/*   number.  This is given in hex in order */
	.word	0xffff		/*   to avoid floating conversions */
