/*
 * Prime the name cache with some useful names.
 *  Should be run once by the initial team; other teams then inherit
 *  these names.  It might be better to read the names from a file
 *  instead of having them compiled into this module.
 */

#include "Vnaming.h"
#include "Vgroupids.h"
#include "Vnamecache.h"

typedef struct
  {
    char *prefix;
    char *truename;
    unsigned short flags;
    ContextPair context;
  }
WKNEntry;

#define VSYS "[storage/any]/usr/V/"
#define xVSYS "[storage/any]/usr/xV/"
#ifdef xV
#define BIN "[storage/any]/usr/xV/bin/"
#define SYS xVSYS
#else
#define BIN "[storage/any]/usr/V/bin/"
#define SYS VSYS
#endif xV

static WKNEntry WellKnownNames[] =
  {
    /* Well-known server groups */

    "[device]", NULL, LOGICAL_PID|DONT_FLUSH,	/* temp use GetPid */
	{ DEVICE_SERVER, DEFAULT_CONTEXT },

    "[internet]", NULL, LOGICAL_PID|DONT_FLUSH,	/* temp use GetPid */
	{ INTERNET_SERVER, DEFAULT_CONTEXT },

    "[service]", NULL, LOGICAL_PID|DONT_FLUSH,	/* temp use GetPid */
	{ SERVICE_SERVER, DEFAULT_CONTEXT },

    "[storage/", NULL, DONT_FLUSH,
	{ VSTORAGE_SERVER_GROUP, STORAGE_SERVER_CONTEXT }, 

    "[storage/local]", NULL, DONT_FLUSH,
        { LSTORAGE_SERVER_GROUP, DEFAULT_CONTEXT },

    "[team/", NULL, DONT_FLUSH,
	{ VTEAM_SERVER_GROUP, TEAM_SERVER_CONTEXT },

    "[team/local]", NULL, DONT_FLUSH,
        { LTEAM_SERVER_GROUP, DEFAULT_CONTEXT },

    "[vgts]", NULL, LOGICAL_PID|DONT_FLUSH,	/* temp use GetPid */
	{ VGT_SERVER, DEFAULT_CONTEXT },

    /* Standard aliases */

    "[bin]", BIN, ALIAS|DONT_FLUSH,
        { 0, 0 },

    "[home]", SYS, ALIAS|DONT_FLUSH,
        { 0, 0 },

    "[homex]", "[team/local]", ALIAS|DONT_FLUSH,
        { 0, 0 },

    "[public]", "[bin]", ALIAS|DONT_FLUSH,	/* temp for compatibility */
        { 0, 0 },

    "[sys]", SYS, ALIAS|DONT_FLUSH,
        { 0, 0 },

    "[V]", VSYS, ALIAS|DONT_FLUSH,
        { 0, 0 },

    "[xV]", xVSYS, ALIAS|DONT_FLUSH,
        { 0, 0 },

    /* End marker */

    NULL, NULL, 0, { 0, 0 }
  };


PrimeCache()
  {
    static ContextPair rootctx = 
	{ VCSNH_SERVER_GROUP, GLOBAL_ROOT_CONTEXT };
    register WKNEntry *wkn;

    wkn = &WellKnownNames[0];

    while (wkn->prefix)
      {
        NameCacheAdd(wkn->prefix, strlen(wkn->prefix), 
		     rootctx, wkn->context, wkn->truename, wkn->flags);
	wkn++;
      }
  }
