/*
 * Read an object's descriptor, specifying the object by name.
 */

#define MAX_PATH_LEN 256
#include "Vnaming.h"
#include "Vdirectory.h"

SystemCode NReadDescriptor(name, desc)
    char *name;
    ArbitraryDescriptor *desc;
  {
    Message msg;
    register DescriptorRequest *req = (DescriptorRequest*)msg;
#define reply	((DescriptorReply*)req)
    /* save the name and descriptor in the same "segment" */
    struct 
      { 
	char			name[MAX_PATH_LEN];
        ArbitraryDescriptor	desc;
      } seg;
    
    strncpy(seg.name, name, sizeof(seg.name));

    /* format the request */
    req->requestcode = NREAD_DESCRIPTOR;
    req->nameindex = 0;
    req->dataindex = MAX_PATH_LEN;
    req->fileid = 0;	/* none */
    req->segmentptr = (char *)(&seg);
    req->segmentlen = sizeof(seg);

    /* route the request to the appropriate server */
    NameSend(req);

    *desc = seg.desc;
    return(reply->replycode);    

#undef reply
  }
