/*
 * Function-call interface to GET_ABSOLUTE_NAME message.  Gets the absolute
 *  name of the object specified by the given relative name.  (Relative to
 *  the current working context.)  The named object need not exist, as long 
 *  as it is clear what its absolute name would be if it were created.
 *
 * Accepts a null-terminated string in name, and modifies it to return
 *  the absolute name.
 * namelength is passed in as the maximum length of the name to be
 *  returned.
 * context is returned if the name specified an existing context; else
 *  context->pid is set to 0.
 */

#include "Vnaming.h"

SystemCode GetAbsoluteName(name, namelength, context)
    char *name;
    unsigned namelength;
    ContextPair *context;
  {
    Message msg;
    register ContextRequest *request = (ContextRequest *) msg;
#define reply ((ContextReply *) request)

    request->requestcode = GET_ABSOLUTE_NAME;
    request->context.pid = 0;
    request->context.cid = 0;
    request->nameindex = 0;
    request->nameptr = name;
    request->namelength = namelength - 1;

    NameSend(request);

    if( reply->replycode != OK )
      {
	*name = NULL;	/* mark string as zero length */
	context->pid = 0;
	context->cid = 0;
        return (reply->replycode);
      }

    /* else terminate the string */
    name[reply->namelength] = NULL;
    *context = reply->context;
    return( reply->replycode );

#undef reply

  } /* GetAbsoluteName */
