/*
 * DefineLocalName()
 * Defines a new local alias for a context in the local name cache.
 *   If the given oldname does not start with the root escape 
 *   character ('['), GetAbsoluteName() is called first, and
 *   newname is aliased to the value it returns.
 *
 * Tim Mann 8-15-85
 */

#include "Vnaming.h"
#include "Vgroupids.h"
#include "Vnamecache.h"
#define NAME_BUF_SIZE 256

SystemCode DefineLocalName(newname, oldname)
    char *newname, *oldname;
  {
    char namebuf[NAME_BUF_SIZE];
    SystemCode err;
    ContextPair context;
    static ContextPair rootcontext =
	 { VCSNH_SERVER_GROUP, GLOBAL_ROOT_CONTEXT } ;

    /* Get the context id for the old name */
    if (*oldname == ROOT_ESCAPE_CHAR)
      {
	/* Absolute name or alias */
	err = GetContextId(oldname, &context);	
      }
    else
      {
	/* Relative name.  Get the absolute name too. */
        strncpy(namebuf, oldname, NAME_BUF_SIZE);
	if (namebuf[NAME_BUF_SIZE-1] != '\0')
	    return BAD_ARGS;  /* name too long */
        err = GetAbsoluteName(namebuf, NAME_BUF_SIZE, &context);
	oldname = namebuf;
      }

    if (err != OK) return err;
    if (context.pid == 0) return INVALID_CONTEXT;  /* not a context */

    /* Now define the alias.
     *  prefix = newname,
     *  length = strlen(newname),
     *  from = global root context
     *  to = context (identifier of context being named),
     *  truename = oldname (absolute name of context)
     *  flags = DONT_FLUSH|ALIAS
     */
    rootcontext.pid = VCSNH_SERVER_GROUP;
    rootcontext.cid = GLOBAL_ROOT_CONTEXT;
    if ( NameCacheAdd(newname, strlen(newname), rootcontext,
	 	      context, oldname, DONT_FLUSH|ALIAS) == NULL ) 
    	return NO_MEMORY;
    
    return OK;
  }
