/*
 * swabSmall(ptr,len)
 *    char *ptr;
 *    unsigned len;
 * 
 * Byte-swap the 16-bit integers at * ptr, for 'len' bytes (NOT words).
 * If len is odd, the number of words swapped is truncated rather than rounded.
 * 
 * Emphasis is on size, not speed (within reason) - if there's a better way to
 * do this, use it.
 */
	.text
	.globl	_swabSmall
_swabSmall:
	.word	0x0004
	movq	4(ap),r0
	ashl	$-1,r1,r1	/* Logical shift would be nice, but it */
				/* doesn't matter; 2^31 bytes is silly */
	brb	swabtest
swabloop:
	movb	1(r0),r2
	movb	(r0)+,(r0)+
	movb	r2,-2(r0)
swabtest:
	sobgeq	r1,swabloop
	ret
