/*
 *  locking.h must define the following operations:
 *
 *  LockTotal()     - lock completely from completely unlocked
 *  UnlockTotal()   - unlock completely (from any state)
 *  LockPartial()   - lock completely from either completely 
 *				or partially unlocked
 *  UnlockPartial() - if totally locked, move to partially unlocked
 *		      if partially locked, move to totally unlocked
 *				
 *	Locking is done via a pseudo-semaphore; a locked-out process
 *	    delays 1 click and tries again.
 *	The lock may be partially released to allow adding space to the
 *	    arena; only such additions may be done by other processes
 *	    until the process holding the partial lock releases it.
 *	This implementation will work in a multiprocessor, but it is
 *	    susceptible to starvation of a waiting process.
 *	Caveat: The C Optimizer changes the bbssi *1,*2,1f/brb *3/1: *4
 *		sequence into a jbcs *1,*2,*3/*4 sequence.  It doesn't
 *		maintain the interlocked (indeed there is no bbcsi
 *		instruction).  So if you use the optimizer, don't use
 *		a multiprocessor machine.
 */

static unsigned AccessSem = 0;

#define UnlockTotal() { asm("	clrl	_AccessSem"); }
#define	UnlockPartial() { asm("	bicb2	$0x80,_AccessSem"); }

#define LockTotal() \
  { \
    asm("3:	bbssi	$7,_AccessSem,1f");	\
    asm("	bitb	$0x01,_AccessSem");	\
    asm("	beql	2f");			\
    asm("	bicb2	$0x80,_AccessSem");	\
    asm("1:");					\
    Delay(0, 1);				\
    asm("	brb	3b");			\
    asm("2:	bisb2	$0x01,_AccessSem");	\
  }

#define LockPartial() \
  { \
    asm("3:	bbssi	$7,_AccessSem,1f");	\
    asm("	brb	2f");			\
    asm("1:");					\
    Delay(0, 1);				\
    asm("	brb	3b");			\
    asm("2:");					\
  }
