
/* 
 * Copy( dest, src, length ) 
 * 
 * Coded using the character move instruction on the VAX.
 */

	.text
	.globl	_Copy
_Copy:
	.word	0x0048		# saves r6 and r3 on call
	movl	4(ap),r3	# destination (dest)
	movl	8(ap),r1	# source (src)
	movl	12(ap),r6	# amount to move (length)
				# r0 is counter used by movc3
	brb	2f		# normal forward case
1:
	subl2	r0,r6		# length = length - 0xFFFF ($65535)
	movc3	r0,(r1),(r3)	# copy 0xFFFF bytes
2:
	movzwl	$0xffff,r0	# load counter with max movc3
	cmpl	r6,r0		# Are we moving that much?
	jgtr	1b		# yes -- jump to copy 0xFFFF
	movc3	r6,(r1),(r3)	# no -- copy length bytes from src to dest
	ret			# and restore register 6

/* END CopyBytes */
