ByteSwapLongInPlace(src, count)
    register char *src;
    register int count;
    /* Byte swap the longs in "src" without copying them anywhere.  "count" 
     * gives the number of bytes to swap.  It is truncated to an integral
     * number of longwords (i.e. divisible by four).
     */
  {
    register char *dst = src + 3;
    register unsigned int temp;

    count >>= 2;	/* number of longs */
    
    while (count-- > 0)
      {
	temp = *src; *src++ = *dst; *dst-- = temp;
	temp = *src; *src++ = *dst; *dst-- = temp;
	src += 2;
	dst += 6;
      }
  }
