/*
 *
 * CONTENTS:
 *	C storage allocator stolen and hacked up from UNIX for the SUN
 *		malloc		)
 *		free		) -> UNIX
 *		realloc		)
 *		GiveToMalloc	) added to support user management
 *		allock		) DEBUG ONLY!
 *
 *	calls GetMoreMallocSpace(minSize,&actualSize) to expand arena;
 *	GetMoreMallocSpace sets actualSize to bytes made available and
 *	  returns pointer to that space
 *
 * AUTHORS: stolen and hacked by Andrew I. Shore
 *
 * MAINTAINER: shore
 *
 * HISTORY:
 * 03/11/82 AIS replaced calls to UNIX sbrk() with calls to own version
 *          SetBrk() for the SUN & Vkernel
 *
 * 05/03/82 AIS changed to work with new multi-team Vkernel -- rather
 *	    than using emt_getchar and _end, now uses the kernel operations
 *	    GetTeamSize and SetTeamSize which more closely approximate
 *	    UNIX sbrk.
 *
 * 05/04/82 AIS fixed some bugs introduced yesterday. Decided to `free' space
 *	    added if SetTeamSize could not grant entire request.
 */

#include <Venviron.h>
#include <malloc.h>

#ifdef debug
#define ASSERT(p) if(!(p))botch("p");else
botch(s)
char *s;
{
	printf("assertion botched: %s\n",s);
	abort("malloc/free: assertion %s failed", s);
}
#else
#define ASSERT(p)
#endif


#ifdef LOCKING
/*
 *  locking.h must define the following operations:
 *
 *  LockTotal()     - lock completely from completely unlocked
 *  UnlockTotal()   - unlock completely (from any state)
 *  LockPartial()   - lock completely from either completely 
 *				or partially unlocked
 *  UnlockPartial() - if totally locked, move to partially unlocked
 *		      if partially locked, move to totally unlocked
 *				
 */

#include <locking.h>
#endif LOCKING

/*	C storage allocator
 *	circular first-fit strategy
 *	works with noncontiguous, but monotonically linked, arena
 *	each block is preceded by a ptr to the (pointer of) 
 *	the next following block
 *	blocks are exact number of words long 
 *	aligned to the data type requirements of ALIGN
 *	pointers to blocks must have BUSY bit 0
 *	bit in ptr is 1 for busy, 0 for idle
 *	gaps in arena are merely noted as busy blocks
 *	last block of arena (pointed to by alloct) is empty and
 *	has a pointer to first
 *	idle blocks are coalesced during space search
 *
 */
static INT   allocs[2] = { ((INT) &allocs[1])+BUSY, ((INT) &allocs[0])+BUSY };
static union store *allocp = (union store *) &allocs[0];	/*search ptr*/
static union store *alloct = (union store *) &allocs[1];	/*arena top*/
static union store *allocx;	/*for benefit of realloc*/

#ifndef LOCKING
char *
malloc(nbytes)
#else   LOCKING
static char *
unlockedMalloc(nbytes)
#endif  LOCKING
unsigned nbytes;
{
	register union store *p, *q;
	register nw;
	static temp,actual;	/*coroutines assume no auto*/
#ifdef LOCKING
	union store *unlockAndGetSpace();
#endif LOCKING
	nw = (nbytes+WORD+WORD-1)/WORD;
	if( (((int) nbytes) < 0) || (nw < 0) )
	    return NULL;

	ASSERT(allocp>=(union store *)allocs && allocp<=alloct);
	ASSERT(allock());
	for(p=allocp; ; ) {
		for(temp=0; ; ) {
			if(!testbusy(p->ptr)) {
				while(!testbusy((q=p->ptr)->ptr)) {
					ASSERT(q>p&&q<alloct);
					p->ptr = q->ptr;
				}
				if(q>=p+nw && p+nw>=p)
					goto found;
			}
			q = p;
			p = clearbusy(p->ptr);
			if(p>q)
				ASSERT(p<=alloct);
			else if(q!=alloct || p!=(union store *)allocs) {
				ASSERT(q==alloct&&p==(union store *)allocs);
				return(NULL);
			} else if(++temp>1)
				break;
		}
		temp = (((nw+BLOCK/WORD)/(BLOCK/WORD))*(BLOCK/WORD))*WORD;
		if( (temp <= 0)
#ifndef LOCKING
		        || ((q = (union store *)
					GetMoreMallocSpace(temp,&actual))
								      == NULL)
			|| (GiveToMalloc( (char *) q, actual) < temp) )
#else   LOCKING
		        || ((q = unlockAndGetSpace(temp,&actual)) == NULL)
			|| (unlockedGiveToMalloc( (char *)q, actual) < temp) )
#endif  LOCKING
		    return NULL;
		
	}
found:
	allocp = p + nw;
	ASSERT(allocp<=alloct);
	if(q>allocp) {
		allocx = allocp->ptr;
		allocp->ptr = p->ptr;
	}
	p->ptr = setbusy(allocp);
	return((char *)(p+1));
}


/*	freeing strategy tuned for LIFO allocation
*/
#ifndef LOCKING
free(ap)
#else   LOCKING
static 
unlockedFree(ap)
#endif  LOCKING
register char *ap;
{
	register union store *p = (union store *)ap;

	ASSERT(p>clearbusy(((union store *)allocs)[1].ptr)&&p<=alloct);
	ASSERT(allock());
	allocp = --p;
	ASSERT(testbusy(p->ptr));
	p->ptr = clearbusy(p->ptr);
	ASSERT(p->ptr > allocp && p->ptr <= alloct);
}

/*	realloc(p, nbytes) reallocates a block obtained from malloc()
 *	and freed since last call of malloc()
 *	to have new size nbytes, and old content
 *	returns new location, or 0 on failure
*/

#ifndef LOCKING
char *
realloc(p, nbytes)
#else   LOCKING
static char *
unlockedRealloc(p, nbytes)
#endif  LOCKING
register union store *p;
unsigned nbytes;
{
	register union store *q;
	int *s, *t;
	register unsigned nw;
	unsigned onw;

	if(testbusy(p[-1].ptr))
#ifndef LOCKING
		free((char *)p);
#else   LOCKING
		unlockedFree((char *)p);
#endif  LOCKING
	onw = p[-1].ptr - p;
#ifndef LOCKING
	q = (union store *)malloc(nbytes);
#else   LOCKING
	q = (union store *)unlockedMalloc(nbytes);
#endif  LOCKING
	if(q==NULL || q==p)
		return((char *)q);
	s = (int *)p;
	t = (int *)q;
	nw = (nbytes+WORD-1)/WORD;
	if(nw<onw)
		onw = nw;
	while(onw--!=0)
		*t++ = *s++;
	if(q<p && q+nw>=p)
		(q+(q+nw-p))->ptr = allocx;
	return((char *)q);
}

#ifdef debug
allock()
{
#ifdef longdebug
	register union store *p;
	int x;
	x = 0;
	for(p= &((union store *)allocs)[0];
		clearbusy(p->ptr) > p; p=clearbusy(p->ptr)) {
		if(p==allocp)
			x++;
	}
	ASSERT(p==alloct);
	return((x==1)||(p==allocp));
#else
	return(1);
#endif
}
#endif


#ifndef LOCKING
int GiveToMalloc(start,length)
#else   LOCKING
static int unlockedGiveToMalloc(start,length)
#endif  LOCKING
    char *start;
    int  length;
  {
    union store *newAlloct;
    union store *alignedStart;
    INT   alignedSize;
    
    /* align start upward */
    alignedStart = (union store *) (((((INT) start)+WORD-1)/WORD)*WORD);
    /* align top downward */
    newAlloct = (union store *) (((((INT) start)+length-WORD)/WORD)*WORD);
    alignedSize = ((INT) newAlloct) - ((INT) alignedStart) + WORD;

    if( (length <= 0)
	    || (newAlloct <= alignedStart)
	    || (alignedStart <= alloct) )
	return 0;

    if( alignedStart == (alloct + 1) )
      {
	newAlloct->ptr = alloct->ptr;
	alloct->ptr = newAlloct;
      }
    else if( (alignedStart > (alloct + 1)) 
		&& (alignedSize >= MIN_BLOCK) )
      {
        /* insert busy block for non-malloc space */
	newAlloct->ptr = alloct->ptr;
	alignedStart->ptr = newAlloct;
	alloct->ptr = setbusy(alignedStart);
      }
    else /* too small to allocate */
	return 0;

    alloct = newAlloct;
    return (int) alignedSize;
  }


#ifdef LOCKING
static union store *
unlockAndGetSpace(temp,actual)
    int temp;
    int *actual;
  {
    union store *result;

    UnlockPartial()
    result = (union store *) GetMoreMallocSpace(temp,actual);
    LockPartial();
    return result;
  }


/* directly callable routines */

char *
malloc(nbytes)
    unsigned nbytes;
  {
    char *result;
    
    LockTotal();
    result = unlockedMalloc(nbytes);
    UnlockTotal();
    return result;
  }

char *
realloc(p,nbytes)
    char *p;
    unsigned nbytes;
  {
    char *result;
    
    LockTotal();
    result = unlockedRealloc(p,nbytes);
    UnlockTotal();
    return result;
  }

free(p)
    char *p;
  {
    LockTotal();
    unlockedFree(p);
    UnlockTotal();
  }

int GiveToMalloc(start,length)
    char *start;
    int  length;
  {
    int result;
    
    LockPartial();
    result = unlockedGiveToMalloc(start,length);
    UnlockPartial();
    return result;
  }
#endif LOCKING
