|Copy : Copy(destination, source, count), returns count
|Optimized for large word-aligned transfers, correct for other types too.

	.globl  Copy
	.globl	blt		| Old name
	.text
Copy:
blt:	movl	sp@(4.),a0	|fetch destination
	movl	sp@(8.),a1	|fetch source
	movl	a0,d0		|see if word aligned
	movl	a1,d1
	orw	d1,d0
	andw	#1,d0
	bnes	notaln		|go if misalignment
	movl	sp@(12.),d1	|fetch count

alignd:	movl	d1,d0		|copy count to d0
	asrl	#3,d0		|divide to get number of 8-byte chunks
	andl	#7,d1		|get number of leftover bytes in d1
	subql	#6,d0		|fast loop moves 6 chunks at a time
				|(we can use subql with 6, speeding inner loop)
	bles	not6		|6 or fewer, just do normal moves
	moveml	#/7F3E,sp@-	|save some registers
	movl	a0,d1		|get dest (a0) minus src (a1)
	subl	a1,d1		|  into d1, then reference both thru a1
blkmv:	moveml	a1@+,#/7DFC	|block move via various registers
	moveml	#/7DFC,a1@(-48,d1:L)
	subql	#6,d0		|going to move another six chunks worth
	bgts	blkmv		|loop if there still are more than six
				|note: we don't loop if =6 because of moveml
				| bug--it reads 1 word past what it should,
				| and thus could cause a bus error.
	movl	a1,a0		|update a0
	addl	d1,a0
	moveml	sp@+,#/7CFE	|restore registers
not6:   asll	#1,d0		|mpy by 2 to get # of words
	addl	#11,d0		|back off on subtraction of 6, -1 for dbf crock
	blts	bytemv		|go if nothing but a few random bytes left
longmv:	movl	a1@+,a0@+	|copy long words (an even number, at most 10)
	dbf	d0,longmv	|while long word count
bytemv:	subql	#1,d1		|correct for dbf crock
	blts	done		|nothing left
bytelp:	movb	a1@+,a0@+	|copy any residual bytes (at most 7)
	dbf	d1,bytelp
done:	movl	sp@(12.),d0	|just return the count
	rts

notaln:	movl	a0,d0		|see if both misaligned
	andw	d1,d0
	movl	sp@(12.),d1	|fetch count
	andw	#1,d0
	beqs	slow		|go if only one misaligned
	subql	#1,d1		|decrement amount to do by 1 byte
	bmis	done		|done if amount was zero (caller is a turkey)
	movb	a1@+,a0@+	|move one byte to get to word boundry
	bra	alignd

slow:	movl	sp@(12.),d1	|count
	subql	#1,d1		|correct for dbf crock
	bmis	done		|done if count was zero (caller is a turkey)
	movl	d1,d0		|get high-order word of count to d0
	swap	d0
slowlp:	movb	a1@+,a0@+	|copy in a nested loop
	dbf	d1,slowlp
	dbf	d0,slowlp
	movl	sp@(12.),d0	|return the count
	rts


