/* Translated from m68k version by J.Wilson and O.Tasar 
 *
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * (Transliterated from Zed and Verex Kernel)
 *
 *  This file assembles into the library routines used to call
 *    kernel operations.  
 *
 *  The space after the dollar signs is mandatory, to get cpp to
 *	realize that n is a symbol unto itself.
 */

/*
 * New and improved kernel trap operations - these exchange all info (except
 *   segments) with the kernel by passing everything in registers.  
 *
 * Standard for talking to the kernel:
 *   r0 = pid           (fromPid for Forwards)	)
 *   r1 = segment pointer (toPid for Forwards)	) Well, maybe ???
 *   r2 = segment size				)
 *   r3-r10 = Message (in/out)
 *   ap - preserved by functions
 *   fp,sp,pc  - Preserved by kernel
 * The stub routines below must save and restore other registers as required.
 *
 * Upon function return, the sp gets what the fp used to be, and then
 *  the pc, fp, and ap are restored from the stack.  This means that if
 *  we don't use the ap between the chmk and the ret instructions, then
 *  we don't need to save and restore it.
 *
 * CAVEAT: No-one said the kernel part of these actually works, did they?
 * NOTE: They work just fine now ! (lance - 11/8/85)
 */

#define SAVE_MASK    0xFFC	/* Saves r2-r11.  Kernel assumes this. */
#define MSG_REG_MASK 0x7F8	/* Put message in r3-r10.	       */

/*
 * ProcessId SendReg( msg, pid )	-- register-based equivalent of Send()
 *   MsgStruct *msg;			--   4(ap)
 *   ProcessId pid;			--   8(ap)
 *
 * Kernel receives 'pid' in r0 and returns the actual pid of the receiver in
 *   r0; this is returned (left in r0) as the value of SendReg()
 * Note: stack pointer is modified so we can use popr and pushr; the 'ret'
 *   restores it.  If anything uses the stack in the interim, we're in trouble.
 */
	.text
	.globl	_Send
_Send:
	.word	SAVE_MASK
	movl	8(ap),r0	/* r0 = pid */
	movl	4(ap),sp	/* sp = msg */
	popr	$MSG_REG_MASK	/* r3-r10 = *msg++ */
	chmk	$0		/* Invoke kernel SendReg_trap */
				/* Now don't clobber r0...    */
	pushr	$MSG_REG_MASK	/* *--msg = r3-10 (reply)     */
	ret

/*
 * ProcessId ForwardReg( msg, fromPid, toPid )
 *   MsgStruct *msg;			--   4(ap)
 *   ProcessId fromPid;			--   8(ap)
 *   ProcessId toPid;			--  12(ap)
 *
 * Kernel returns (in r0) toPid if successful, 0 otherwise.
 */
	.text
	.globl	_Forward
_Forward:
	.word	SAVE_MASK
	movq	8(ap),r0	/* r0 = fromPid) -- m68k version of kernellib*/
				/* r1 = toPid  ) -- uses a different order   */
	movl	4(ap),sp	/* sp = msg */
	popr	$MSG_REG_MASK	/* r3-r10 = *msg++ */
	chmk	$1		/* Invoke kernel ForwardReg_trap */
	ret			/* .. and return r0 */

/*
 * ProcessId ReceiveReg( msg, ptr, size, pid )
 *   MsgStruct *msg;			--   4(ap)
 *   char      *ptr;			--   8(ap)
 *   int       *size;			--  12(ap)
 *   ProcessId pid;			--  16(ap)
 *
 * Kernel returns sender's pid in r0, actual segment size in r1
 */
	.text
	.globl	__Receive
__Receive:
	.word	SAVE_MASK
	movl	16(ap),r0	/* r0 = pid */
	movl	 8(ap),r1	/* r1 = address of segment (or 0)*/
	movl	*12(ap),r2	/* r2 = segment size             */
	pushl	ap		/* save the ap */
	chmk	$2		/* Invoke kernel ReceiveReg_trap */
				/* Now don't clobber r0...    */
	movl	(sp)+, ap	/* restore ap */
	movl	r1, *12(ap)	/* Return size */
	addl3	4(ap),$32,sp	/* sp -> end of msg */
	pushr	$MSG_REG_MASK	/* *--msg = r3-10 (request)   */
	ret

/*
 * ProcessId ReplyWithSeg( msg, pid, ptr );
 *   MsgStruct *msg;			--   4(ap)
 *   ProcessId pid;			--   8(ap)
 *   char      *ptr;			--  12(ap)
 *
 * Kernel returns (in r0) pid if successful, 0 otherwise.
 */
	.text
	.globl	_ReplyWithSeg
_ReplyWithSeg:
	.word	SAVE_MASK
	movq	8(ap),r0	/* r0 = pid */
				/* r1 = address of segment (or 0)*/
	movl	4(ap),sp	/* sp = msg */
	popr	$MSG_REG_MASK	/* r3-r10 = *msg++ */
	chmk	$3		/* Invoke kernel ReplyWithSeg_trap */
	ret			/* .. and return r0 */

/*
 * ProcessId GetReply( msg, timeout_count );
 *   MsgStruct	*msg;		-- 4(ap)
 *   long	timeout_count;	-- 8(ap)
 *
 * Returns zero if the process times out before a reply comes in.
 */
 
	.text
	.globl	_GetReply
_GetReply:
	.word	SAVE_MASK
	movq	8(ap),r1	/* r1 = timeout count */
	pushl	ap
	chmk	$12
	movl	(sp)+, ap
	addl3	4(ap),$32,sp	/* sp -> end of msg */
	pushr	$MSG_REG_MASK	/* *--msg = r3-10 (request)   */
	ret			/* .. and return r0 */
	
 
