/*
 * Copyright (c) 1983 by Stanford University, all rights reserved.
 * V Kernel Interface
 *
 * 	QueryGroup
 */

#include "Venviron.h"

SystemCode QueryGroup( groupId, pid )
    GroupId groupId; ProcessId pid;
   /* Query the kernel to see if pid would be allowed to
    * joing the group with the specified groupId.
    * Returns OK if so otherwise NO_PERMISSION is not
    * allowed, DUPLICATE_NAME is already in, and NOT_FOUND
    * if group does not exist - not at least one member located.
    */
  {
    Message msg;
    KernelRequest *req = (KernelRequest *) msg;
    extern ProcessId Kernel_Process_Pid;

    req->opcode = QUERY_GROUP;
    req->pid = pid;
    req->unspecified[0] = groupId;

    Send( req, Kernel_Process_Pid );

    return( req->opcode );
  }
