
/* Machine independant support routines for kernel traps */
#include <Venviron.h>

extern ProcessId Send(), _Receive(), ReplyWithSeg(), Forward();
extern SystemCode MoveTo();

ProcessId ReceiveWithSegment(msg, ptr, size)
MsgStruct *msg;
char *ptr;
unsigned long *size;
  {
    return (_Receive(msg, ptr, size, 0));
  }

ProcessId Receive( msg )
char *msg;
  {
    int size = 0;
    return( _Receive( msg, NULL, &size, 0 ) );
  }

ProcessId ReceiveSpecific( msg, pid )
MsgStruct *msg;
ProcessId pid;
  {
    int size = 0;
    return(_Receive( msg, NULL, &size, pid ) );
  }

ReplyWithSegment( msg, pid, src, dest, bytes )
MsgStruct *msg;
ProcessId pid;
char *src, *dest;
unsigned bytes;
  {
    if ( (msg->segmentPtr == dest) && (msg->segmentSize == bytes) )
      {
	msg->sysCode |= REPLY_SEGMENT_BIT;
	return( ReplyWithSeg( msg, pid, src ) );
      }

    msg->sysCode &= ~REPLY_SEGMENT_BIT;
    if ( MoveTo( pid, dest, src, bytes ) != OK )
      {
	msg->sysCode = BAD_REPLY_SEGMENT;
	ReplyWithSeg( msg, pid, NULL );
	return( 0 );
      }

    return( ReplyWithSeg( msg, pid, NULL ) );
  }

Reply( msg, pid )
MsgStruct *msg;
ProcessId pid;
  {
    msg->sysCode &= ~REPLY_SEGMENT_BIT;
    return( ReplyWithSeg( msg, pid, NULL ) );
  }
